<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Login</title>
@include('head')

</head>
<body>
@include('header')

  <section class="hero-section">
    <div class="container">
      <div class="row g-4 align-items-center">
        <div class="col-lg-6">
            <img src="{{asset('assets/login.png')}}" class="img-fluid" alt="sign up"/>
        </div>

        <!-- Right side: signup form -->
         <div class="col-lg-5 ms-lg-auto">
          <div class="signup-card">
            
            <!-- Role toggle -->
            <div class="signup-tabs">
              <button type="button" class="signup-tab active">BeniSS User</button>
              <button type="button" class="signup-tab" disabled>BeniSS Partner</button>
            </div>
            <h4 class="mb-4 text-center">Login as BeniSS User</h4>

            <form action="{{route('loginpasscode')}}" method="POST">
              <!-- Mobile number -->
              @csrf

              @error('email_or_phone')
          <div class="text-danger mb-2">
        {{ $message }}
         </div>
            @enderror
              <div class="mb-3">
                <!-- <label class="form-label" for="referralCode">Referral Code</label> -->
                <input type="text" class="form-control" name="email_or_phone" id="referralCode" placeholder="Email Id / Phone Number"/>
              </div>

              

              <!-- Get OTP -->
              <button type="submit" class="btn btn-otp mb-2">
               Log in
              </button>

              <!-- OR divider -->
              <div class="divider">
                <span>or</span>
              </div>

              <!-- Already have account -->
              <p class="text-center small already-text mb-0">
                Don’t Have an Account ?
                <a href="{{route('signup')}}">Sign Up</a>
              </p>
            </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Simple toggle for User / Partner (visual only) -->
  <script>
    const tabs = document.querySelectorAll(".signup-tab");
    tabs.forEach(tab => {
      tab.addEventListener("click", () => {
        tabs.forEach(t => t.classList.remove("active"));
        tab.classList.add("active");
        // Here you can add logic to change form fields based on selection
      });
    });
  </script>
</body>
</html>
