<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8" />
      <title>BeniSS Global - Dashboard</title>
 @include('head')
      <style>
         .stats-wrap {
  position: relative;
  background: #ffffff;
  border-radius: 20px;
  padding: 28px 32px;
}
         .stats-wrap::before {
  content: "";
  position: absolute;
  inset: 0;
  padding: 2px; /* border thickness */
  border-radius: 20px;
  background: linear-gradient(90deg, #E79901 0%, #FFFFFF 100%);
  -webkit-mask:
    linear-gradient(#fff 0 0) content-box,
    linear-gradient(#fff 0 0);
  -webkit-mask-composite: xor;
          mask-composite: exclude;
  pointer-events: none;
}
      </style>
   </head>
   <body>
      @include ('header-dashboard')
      <section class="hero-section">
         <div class="container">
            <div class="row g-4 align-items-center">
               <!-- Right side: signup form -->
               <div class="col-lg-12 ms-lg-auto">
                  <div class="signup-card">
                     <h4 class="text-center">Hey {{ auth()->user()->name }} !</h4>
                     <p class="text-center" style="margin: 0">
                        here’s what’s happening till today
                     </p>
                     <div class="container stats-wrap mt-4">
                        <div class="row g-3">
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <small>TOTAL AMOUNT INVESTED</small>
                                 <h4>
                                    <!--<span>₹{{ $credit_principal }}</span>-->
                                     <span>₹0</span>
                                    <span class="text-success percent">+ 36% ↑</span>
                                 </h4>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <small>TOTAL AMOUNT WITHDRAWAL</small>
                                 <h4>
                                    <!--<span>₹{{ $Total_Withdrawl }}</span>-->
                                    <span>₹0</span>
                                    <span class="text-success percent">+ 36% ↑</span>
                                 </h4>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <small>NET PORTFOLIO VALUE</small>
                                 <h4>
                                    <!--<span>₹{{ $Net_portfolio_value }}</span>-->
                                     <span>₹0</span>
                                    <span class="text-success percent">+ 36% ↑</span>
                                 </h4>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <small>TOTAL RETURN</small>
                                 <h4>
                                    <!--<span>₹{{ $Total_Return_Earned }}</span>-->
                                     <span>₹0</span>
                                    <span class="text-danger percent">–14% ↓</span>
                                 </h4>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <small>Return Received</small>
                                 <h4>
                                    <!--<span>₹{{ $Return_Received }}</span>-->
                                     <span>₹0</span>
                                    <span class="text-danger percent">–14% ↓</span>
                                 </h4>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <small>Return Receivable</small>
                                 <h4>
                                    <!--<span>₹{{ $Return_Receivable }}</span>-->
                                     <span>₹0</span>
                                    <span class="text-danger percent">–14% ↓</span>
                                 </h4>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                  <h4>Explore BeniSS</h4>
                  <div class="row g-3 mt-3">
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span>Investment</span>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span>Cash Loan</span>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span>Insurance</span>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span>Units</span>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                  <h4>Sponsored Products</h4>
                  <div class="big-box mt-3"></div>
                  <div class="bottom-strip">Line Related to ad</div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                  <h4>What’s New ?</h4>
                  <div class="row g-3 mt-3">
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span>Marketing & Communication
                           <span class="time">2 Days Ago</span>
                           </span>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span>Marketing & Communication 
                           <span class="time">2 Days Ago</span>
                           </span>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span>Marketing & Communication <span class="time">2 Days Ago</span></span>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span>Marketing & Communication <span class="time">2 Days Ago</span></span>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                  <h4>Continue Where You Left </h4>
                  <div class="big-box mt-3"></div>
                  <div class="bottom-strip">Line Related to ad</div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                  <div id="wealthSlider" class="carousel slide" data-bs-ride="carousel">
    <div class="carousel-inner">

        <!-- Slide 1 -->
        <div class="carousel-item active">
            <div class="wealth-card">
                <div class="wealth-content">
                    <div class="row align-items-center">
                        <div class="col-md-7">
                            <div class="wealth-title">Build Your Wealth</div>
                            <div class="wealth-subtitle">
                                By Investing Through <span>BeniSS Global</span>
                            </div>
                        </div>
                        <div class="col-md-5 text-end wealth-image">
                            <img src="images/financial.png" alt="Wealth">
                        </div>
                    </div>
                </div>
                <div class="wealth-footer">
                    25 Lakhs+ Users Invest in BeniSS Global
                </div>
            </div>
        </div>

        <!-- Slide 2 -->
        <div class="carousel-item">
            <div class="wealth-card">
                <div class="wealth-content">
                    <div class="row align-items-center">
                        <div class="col-md-7">
                            <div class="wealth-title">Secure Your Future</div>
                            <div class="wealth-subtitle">
                                With <span>BeniSS Global</span>
                            </div>
                        </div>
                        <div class="col-md-5 text-end wealth-image">
                            <img src="images/financial.png" alt="Wealth">
                        </div>
                    </div>
                </div>
                <div class="wealth-footer">
                    Trusted by Millions of Investors
                </div>
            </div>
        </div>

    </div>

    <!-- Controls -->
    <button class="carousel-control-prev" type="button" data-bs-target="#wealthSlider" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#wealthSlider" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
    </button>
</div>
               </div>

               <div class="col-lg-12 ms-lg-auto">
                  <h4>BeniSS Global Loan Terms</h4>
                  <div class="listLoan">
                    <h6>Cash Loan</h6>
                    <ul>
                      <li>Loan Amount Up to <b>₹ 20,00,000</b></li>
                      <li>Loan Tenure Up to  84 Months</li>
                      <li>Interest Rates Range From 12.06% to 29.96%</li>
                    </ul>
                    <a href="#">Know More</a>
                  </div>

                  <div class="listLoan">
                    <h6>MSME Loan</h6>
                    <ul>
                      <li>Loan Amount Up to <b>₹ 20,00,000</b></li>
                      <li>Loan Tenure Up to  84 Months</li>
                      <li>Interest Rates Range From 12.06% to 29.96%</li>
                    </ul>
                    <a href="#">Know More</a>
                  </div>
               </div>
            </div>
         </div>
      </section>

      <footer>
        <img src="images/iso.png">
        <span class="isoText">ISO 27001 Certified</span>
      </footer>
      <!-- Bootstrap JS -->
      <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
   </body>
</html>