<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Order Summary</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body style="background:#f5f5f5;">

    <div class="container py-4">
        <div class="row justify-content-center">
            <div class="col-lg-8">

                <!-- Card -->
                <div class="bg-white rounded-3 p-4 shadow-sm">

                    <!-- Title -->
                    <h5 class="fw-semibold mb-3">Order Summary</h5>
                    <hr>

                    <!-- Item 1 -->
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="d-flex align-items-center gap-3">
                            <img src="images/companyLogo.png" class="img-fluid" style="max-width:40px;">
                            <div class="fw-medium"><?php echo e($productName); ?></div>
                        </div>
                        <div class="text-end">
                            <div class="fw-semibold">₹<?php echo e(number_format($amount)); ?></div>
                            <small class="text-muted">Qty: <?php echo e($unit); ?></small>
                        </div>
                    </div>

                    <hr>

                    <!-- Subtotal -->
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">Total</span>
                        <span class="fw-medium">₹<?php echo e(number_format($amount)); ?></span>
                    </div>

                    <hr>

                    <!-- Total -->
                    <!--<div class="d-flex justify-content-between align-items-center mb-4">-->
                    <!--    <div>-->
                    <!--        <div class="fw-semibold">Total</div>-->
                    <!--        <small class="text-muted">Including all Charges</small>-->
                    <!--    </div>-->
                    <!--    <div class="fw-semibold fs-3">₹70,000.00</div>-->
                    <!--</div>-->

                    <!-- Attach File -->
                    
                    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <?php echo e($errors->first()); ?>

    </div>
<?php endif; ?>
                    <form method="POST"
      action="<?php echo e(route('receipt.upload.submit')); ?>"
      enctype="multipart/form-data">
                         <?php echo csrf_field(); ?>
                    <div class="mb-4">
                        <h6 class="fw-semibold mb-2">Attach File</h6>
                        
                      <input type="hidden" name="dealid" value="<?php echo e($dealid); ?>">

                        <label class="w-100 text-center p-4 border border-2 border-dashed rounded"
                            style="cursor:pointer;">
                            <div class="mb-2 fs-4">
                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="21" viewBox="0 0 22 21"
                                    fill="none">
                                    <path
                                        d="M10.9914 10.0153V19.0153M10.9914 10.0153L8.49142 12.0153M10.9914 10.0153L13.4914 12.0153M4.02542 7.13232C3.07963 7.37032 2.25329 7.94548 1.70167 8.74977C1.15005 9.55405 0.911099 10.5321 1.02972 11.5001C1.14835 12.4681 1.61638 13.3595 2.34588 14.0068C3.07538 14.6541 4.01615 15.0127 4.99142 15.0153H5.99142"
                                        stroke="#191D23" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M14.8219 5.15334C14.4801 3.79992 13.6364 2.62708 12.462 1.8726C11.2875 1.11812 9.87013 0.838434 8.49711 1.09025C7.1241 1.34206 5.8982 2.10653 5.06792 3.22868C4.23764 4.35084 3.86512 5.74671 4.02586 7.13334C4.02586 7.13334 4.17886 8.01534 4.49186 8.51534"
                                        stroke="#191D23" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M15.9912 15.0154C16.6972 15.0149 17.3952 14.8649 18.0391 14.5752C18.683 14.2856 19.2582 13.8628 19.7269 13.3349C20.1957 12.8069 20.5473 12.1856 20.7586 11.5119C20.9699 10.8382 21.0362 10.1274 20.953 9.42633C20.8698 8.7252 20.6391 8.04965 20.276 7.44412C19.9129 6.83859 19.4257 6.31683 18.8464 5.91317C18.2672 5.5095 17.609 5.2331 16.9152 5.10214C16.2214 4.97118 15.5078 4.98865 14.8212 5.15338L13.4912 5.51538"
                                        stroke="#191D23" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                            </div>
                            <div class="text-muted">
                                Browse and choose the files you want to upload from your computer
                            </div>
                            <!--<div class="mb-2 fs-4">-->
                            <!--    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"-->
                            <!--        fill="none">-->
                            <!--        <rect width="32" height="32" rx="4" fill="#002233" />-->
                            <!--        <path-->
                            <!--            d="M16.833 10.1666C16.833 9.70635 16.4599 9.33325 15.9997 9.33325C15.5394 9.33325 15.1663 9.70635 15.1663 10.1666V15.1666H10.1663C9.7061 15.1666 9.33301 15.5397 9.33301 15.9999C9.33301 16.4602 9.7061 16.8333 10.1663 16.8333H15.1663V21.8333C15.1663 22.2935 15.5394 22.6666 15.9997 22.6666C16.4599 22.6666 16.833 22.2935 16.833 21.8333V16.8333H21.833C22.2932 16.8333 22.6663 16.4602 22.6663 15.9999C22.6663 15.5397 22.2932 15.1666 21.833 15.1666H16.833V10.1666Z"-->
                            <!--            fill="white" />-->
                            <!--    </svg>-->
                            <!--</div>-->
                            <input type="file" name= "receipt" >
                        </label>
                    </div> 

                    <!-- Submit -->
                    <div class="d-grid gap-2 d-md-flex justify-content-md-center my-3">
                        <button type="submit" class="btn text-white rounded-pill px-5 fw-semibold"
                            style="background:#E79901">
                            Submit
                        </button>
                    </div>
                    
                    
                    </form>

                </div>

            </div>
        </div>
    </div>

</body>

</html><?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/paymentsummary.blade.php ENDPATH**/ ?>