<!DOCTYPE html>
<html>
<head>
    <title>Will You Marry Me?</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        body {
            margin: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            background: linear-gradient(to bottom right, #ff9a9e, #ff758c);
            font-family: Arial, sans-serif;
            text-align: center;
            overflow: hidden;
        }

        h1 {
            color: white;
            font-size: 28px;
            padding: 20px;
        }

        .message {
            color: white;
            margin-top: 10px;
            font-size: 18px;
            height: 30px;
        }

        .btn-container {
            position: relative;
            width: 100%;
            height: 200px;
        }

        button {
            padding: 15px 35px;
            font-size: 18px;
            border-radius: 50px;
            border: none;
            cursor: pointer;
            position: absolute;
            transition: all 0.3s ease;
        }

        .yes-btn {
            background: #28a745;
            color: white;
            left: 25%;
            top: 80px;
            box-shadow: 0 0 15px rgba(255,255,255,0.7);
        }

        .no-btn {
            background: #dc3545;
            color: white;
            left: 55%;
            top: 80px;
        }
    </style>
</head>
<body>

    <h1>
        Kunal Bhardwaj ❤️<br>
        Will You Marry Me? 💍
    </h1>

    <div class="message" id="message"></div>

    <div class="btn-container" id="container">

        <form action="<?php echo e(route('proposal.yes')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <button type="submit" class="yes-btn">YES 💖</button>
        </form>

        <button class="no-btn" id="noBtn">NO 😢</button>

    </div>

<script>
    const noBtn = document.getElementById("noBtn");
    const message = document.getElementById("message");
    const container = document.getElementById("container");

    let attempt = 0;

    const emotionalMessages = [
        "Are you sure? 🥺",
        "Think again… ❤️",
        "My heart will break 💔",
        "Please don’t do this 😭",
        "Okay fine… you can’t say no 😌"
    ];

    function moveButton() {
        attempt++;

        const maxX = container.offsetWidth - noBtn.offsetWidth;
        const maxY = container.offsetHeight - noBtn.offsetHeight;

        const randomX = Math.floor(Math.random() * maxX);
        const randomY = Math.floor(Math.random() * maxY);

        noBtn.style.left = randomX + "px";
        noBtn.style.top = randomY + "px";

        if (attempt <= emotionalMessages.length) {
            message.innerText = emotionalMessages[attempt - 1];
        }

        // Shrink button every time
        let currentSize = 18 - attempt * 2;
        if (currentSize > 8) {
            noBtn.style.fontSize = currentSize + "px";
            noBtn.style.padding = (15 - attempt * 2) + "px " + (35 - attempt * 4) + "px";
        }

        // After 5 tries → disappear
        if (attempt >= 5) {
            noBtn.style.display = "none";
            message.innerText = "See… destiny wants YES 💍❤️";
        }
    }

    noBtn.addEventListener("touchstart", moveButton);
    noBtn.addEventListener("click", moveButton);
</script>

</body>
</html><?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/proposal.blade.php ENDPATH**/ ?>