<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Login OTP</title>
<?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>
<body>
<?php echo $__env->make('header-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 
  <section class="hero-section">
    <div class="container">
      <div class="row g-4 align-items-center">
        <div class="col-lg-6">
            <img src="<?php echo e(asset('assets/login-otp-2.png')); ?>" class="img-fluid" alt="sign up"/>
        </div>

        <!-- Right side: signup form -->
        <div class="col-lg-5 ms-lg-auto">
          <div class="signup-card">
            
           
            <h4 class="mb-4 text-center">Aadhaar KYC</h4>

<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div><?php echo e($error); ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php endif; ?>
<?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>

           <form action="<?php echo e(route('aadhaar.start')); ?>" method="POST">
    <?php echo csrf_field(); ?>
              <ul class="font12">
                <li>The Aadhaar and PAN <b><?php echo e(session('pan_number') ?? ''); ?></b> should belong to you, the applicant. If it does not, <span style="color: #E79901; font-weight: 600;">Start Over</span>.
                </li>
                <li>You will be redirected to Digilocker for aadhaar OTP verification.
                </li>
                <li>By proceeding, you agree that you have read the Aadhaar user consent document and voluntarily consent to share your PAN and Aadhaar information (excluding the Aadhaar number). Learn more</li>
              </ul>

              <div class="mb-3 form-check">
                <input type="checkbox" class="form-check-input"  name="consent" id="termsCheck">
                <label class="form-check-label small" for="termsCheck">
                   I authorise BeniSS Global to fetch my KYC information from the CKYC registry with my PAN.
                </label>
              </div>

              <!-- Get OTP -->
              <button type="submit" class="btn btn-otp mb-2">
               Continue
              </button>

            </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Simple toggle for User / Partner (visual only) -->
  <script>
    const tabs = document.querySelectorAll(".signup-tab");
    tabs.forEach(tab => {
      tab.addEventListener("click", () => {
        tabs.forEach(t => t.classList.remove("active"));
        tab.classList.add("active");
        // Here you can add logic to change form fields based on selection
      });
    });
  </script>
</body>
</html>
<?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/adhar-kyc-1.blade.php ENDPATH**/ ?>