<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Withdrawal Form - BeniSS Global</title>
<?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<style>
 
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: Arial, Helvetica, sans-serif;
}
 
body {
    background: #f5f6f8;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    padding: 20px;
}
 
/* Main Card */
.form-container {
    background: #ffffff;
    width: 800px;
    max-width: 100%;
    padding: 40px;
    border-radius: 14px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.06);
}
 
/* Title */
.form-title {
    text-align: center;
    margin-bottom: 8px;
    font-size: 28px;
    font-weight: 600;
    color: #1f2937;
}
 
.form-subtitle {
    text-align: center;
    font-size: 14px;
    color: #6b7280;
    margin-bottom: 35px;
}
 
/* 2 Column Layout */
.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px 25px;
}
 
/* Full width field */
.full-width {
    grid-column: span 2;
}
 
/* Form Group */
.form-group {
    display: flex;
    flex-direction: column;
}
 
label {
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 6px;
    color: #374151;
}
 
input, select, textarea {
    padding: 11px 12px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    font-size: 14px;
    transition: 0.2s ease;
    background: #ffffff;
}
 
input:focus, select:focus, textarea:focus {
    outline: none;
    border-color: #E79901;
    box-shadow: 0 0 0 2px rgba(231, 153, 1, 0.15);
}
 
/* Readonly style */
input[readonly], textarea[readonly] {
    background: #f3f4f6;
}
 
/* Button */
.primary-btn {
    margin-top: 30px;
    width: 100%;
    padding: 13px;
    border: none;
    border-radius: 8px;
    background: #E79901;
    color: white;
    font-size: 15px;
    font-weight: 600;
    cursor: pointer;
    transition: 0.2s ease;
}
 
.primary-btn:hover {
    background: #cf8700;
}
 
/* Footer */
.footer-text {
    text-align: center;
    margin-top: 18px;
    font-size: 13px;
    color: #6b7280;
}
 
.footer-text a {
    color: #E79901;
    text-decoration: none;
    font-weight: 600;
}
 
/* Responsive */
@media (max-width: 768px) {
    .form-grid {
        grid-template-columns: 1fr;
    }
 
    .full-width {
        grid-column: span 1;
    }
}
 
</style>

</head>

<body style="display: block;">
    
     <?php echo $__env->make('header-dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<form method="POST" action="<?php echo e(route('withdrawl.attachment')); ?>">
    <?php echo csrf_field(); ?>
<div class="form-container" style="margin:auto;">
 
    <div class="form-title">Withdrawal Form</div>
    <div class="form-subtitle">
        Please review your details before continuing
    </div>
 
    <form>
 
        <div class="form-grid">
 
            <div class="form-group">
                <label>Name</label>
                <input type="text" value="<?php echo e($name); ?>" readonly>
            </div>
 
            <div class="form-group">
                <label>Father's Name</label>
                <input type="text" value="<?php echo e($fathername); ?>" readonly>
            </div>
 
            <div class="form-group full-width">
                <label>Complete Address</label>
                <textarea rows="3" readonly>
<?php echo e($address); ?>

                </textarea>
            </div>
 
            <div class="form-group">
                <label>Phone Number</label>
                <input type="text" value="<?php echo e($phone); ?>" readonly>
            </div>
 
            <div class="form-group">
                <label>Email ID</label>
                <input type="email" value="<?php echo e($email); ?>" readonly>
            </div>
 
            <div class="form-group">
                <label>PAN Number</label>
                <input type="text" value="<?php echo e($pan); ?>" readonly>
            </div>
 
            <div class="form-group">
                <label>Security Type</label>
                 <select class="form-select" name="security_type">
                                                        <option value=""  selected disabled>Select Security Type</option>
                                                       
                                                        <option value="NCD">NCD</option>
                                                        <option value="CCPS">CCPS</option>
                                                        <option value="NCPS">NCPS</option>
                                                        <option value="Equity">Equity</option>
                                                    </select>
            </div>
 
        </div>
 
        <button type="submit" class="primary-btn">
            Continue
        </button>
 
    </form>
 
  
 
</div>
 
</body>
</html><?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/withdrawlform.blade.php ENDPATH**/ ?>