<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>BeniSS Global - Dashboard</title>
    <?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <style>
    .custom-px {
        padding-left: 5.5rem;
        padding-right: 5.5rem;
    }

    .custom-py {
        padding-top: 2rem;
        padding-bottom: 2rem;
    }

    @media (max-width: 1000px) {

        .custom-px {
            padding-left: 2.5rem;
            padding-right: 2.5rem;
        }

        .WealthCard {
            margin: auto;
        }

        .WealthCardText {
            margin: auto;
        }

        .WealthCardHeading {
            text-align: center;
        }

        .WealthCardButton {
            margin: auto;
        }

        .tab {
            overflow-x: scroll;


        }

        .nav {
            width: max-content;
        }

        .cardHeading {
            padding-top: 8%;
        }




    }

    /* CARD GRADIENT BACKGROUND */
    .invest-card {
        border-radius: 18px;
        position: relative;
        overflow: hidden;
    }

    .invest-card-bg {
        background-image: url("images/frame.png");
        /* your image */
        background-repeat: no-repeat;
        background-position: right top;
        background-size: cover;
        border-radius: 1rem;
        /* matches rounded-4 */
        padding-bottom: 0;
        /* footer already handles spacing */
    }


    /* HIGH YIELD RIBBON */
    .high-yield {
        background: linear-gradient(90deg, #c6b6f5, #d8c9fb);
        color: #1b1b1b;
        font-weight: 600;
        font-size: 12px;
        padding: 10px 45px;
        border-radius: 0 0 0 14px;
        position: absolute;
        top: 0;
        right: 0;
    }

    /* BBB BADGE */
    .rating-badge {
        background: #ffffff;
        border: 1px solid #e6e6e6;
        font-weight: 600;
        padding: 6px 14px;
    }

    /* STAT BOX */
    .stat-box {
        background: rgba(255, 255, 255, 0.7);
        /* 70% opacity */
        border: 1px solid #e6edf5;
        border-radius: 10px;
        padding: 14px 12px;
        text-align: left;
    }

    /* FOOTER STRIP */
    .card-footer-strip {
        background: #062636;
        color: #ffffff;
        font-size: 13px;
        padding: 12px 104px;
        border-radius: 0 14px 0 0;
        width: fit-content;
    }

    .help-card {
        border-bottom: none
    }


    .help-card::before {
        content: "";
        position: absolute;
        inset: 0;
        padding: 1.5px;
        border-radius: inherit;
        background: linear-gradient(180deg, #E79901 0%, #FFFFFF 100%);
        -webkit-mask:
            linear-gradient(#fff 0 0) content-box,
            linear-gradient(#fff 0 0);

        mask-composite: exclude;
    }
    </style>
</head>

<body>
    <?php echo $__env->make('header-dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- FIXED DISCOVER SECTION -->
    <section style="background:#062636; z-index:1020;">
        <div class="container pt-4">
            <!-- TITLE -->
            <h3 class="text-white text-center fw-bold pb-4">
                Discover Opportunity for Withdrawal
            </h3>



        </div>

    </section>

    <!-- SCROLLABLE CONTENT -->
    
        <!-- rest of page -->

        <!-- SCROLLABLE CONTENT -->
        <div class="container py-4">
            <?php $__empty_1 = true; $__currentLoopData = $deals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

            <!-- INVESTMENT CARD -->
            <div class="card border-0 shadow-sm mb-4 invest-card">
                <div class="invest-card-bg">
                    <!-- HIGH YIELD RIBBON -->
                    <div class="high-yield">High Yield</div>

                    <!-- HEADER -->
                    <div class="cardHeading d-flex justify-content-between align-items-start mb-4"
                        style=" margin-top: 5%; padding-right: 8%;">
                        <div class="d-flex align-items-center gap-3 px-5">
                           <img src="<?php echo e(route('product.photo', $deal['Products']['id'])); ?>" width="70" />
                            <h6 class="fw-bold mb-0"><?php echo e($deal['Products']['name'] ?? 'N/A'); ?></h6>
                        </div>

                        <div class="d-flex align-items-center gap-3 px-5">
                            <h6 class="fw-bold mb-0">
                                <?php echo e(!empty($deal['Closing_Date']) 
                        ? \Carbon\Carbon::parse($deal['Closing_Date'])->format('d-m-Y') 
                        : '-'); ?>

                            </h6>
                        </div>

                        <span class="badge rating-badge rounded-pill text-dark fw-bold">
                            BBB+
                        </span>
                    </div>

                    <!-- STATS -->
                    <div class="row g-3 px-5 mb-3">
                        <div class="col-md-4">
                            <div class="stat-box">
                                <h6 class="fw-bold mb-1"><?php echo e($deal['ROI'] ?? 'NA'); ?> %</h6>
                                <small class="text-muted">INTEREST</small>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="stat-box">
                                <h6 class="fw-bold mb-1"><?php echo e($deal['Unit'] ?? 0); ?></h6>
                                <small class="text-muted">Number of lots</small>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="stat-box">
                                <h6 class="fw-bold mb-1">₹ <?php echo e(number_format($deal['Investment_Amount'] ?? 0)); ?></h6>
                                <small class="text-muted">INVESTED</small>
                            </div>
                        </div>
                    </div>

                    <!-- CTA BUTTON -->
                    <div class="text-center my-4">
                        <div class="text-center mb-4">
                            <button class="btn text-white fw-semibold px-5 py-2 rounded-pill openModalBtn"
                                style="background:#E79901" data-product="<?php echo e($deal['Products']['name'] ?? 'N/A'); ?>"
                                data-price="<?php echo e($deal['Investment_Amount'] ?? 0); ?>"
                                data-maxunit="<?php echo e($deal['Unit'] ?? 1); ?>" data-dealid="<?php echo e($deal['id']); ?>">
                                Raise a Request
                            </button>
                        </div>

                        <!-- FOOTER STRIP -->
                        <div class="card-footer-strip">
                            Interest Quarterly &nbsp;|&nbsp; Principal At Maturity
                        </div>

                    </div>
                </div>


                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center text-muted py-5">
                    No approved investment requests found.
                </div>
                <?php endif; ?>

          

        </div>
        
        <div class="d-flex justify-content-left mt-4">
    <?php echo e($deals->links('pagination::bootstrap-5')); ?>

</div>
        <footer>
            <img src="<?php echo e(asset('assets/iso.png')); ?>">
            <span class="isoText">ISO 27001 Certified</span>
        </footer>

        <!-- MODAL -->
        <div class="modal fade" id="addUnitsModal" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content rounded-4 overflow-hidden">

                    <!-- HEADER -->
                    <div class="modal-header border-0 text-white" style="background:#062636;">
                        <h5 class="modal-title">Withdrawal Units</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>

                    <!-- BODY -->
                    <div class="modal-body p-4">

                        <!-- LOGO -->
                        <div class="text-center">
                            <img src="<?php echo e(asset('assets/companyLogo.png')); ?>" width="70">
                        </div>

                        <!-- COMPANY NAME -->
                        <h6 class="text-center fw-bold mb-3" id="modalProductName"></h6>


                        <!-- PRICE + UNITS -->
                        <div class="row g-3 mb-3">
                            <div class="col-6">
                                <label class="form-label fw-semibold">Per lot amount</label>
                                <input type="text" class="form-control" id="modalPricePerUnit" readonly>
                            </div>

                            <div class="col-6">
                                <label class="form-label fw-semibold">Number of Units</label>
                                <div class="input-group">
                                    <button class="btn  text-white" style="background:#E79901"
                                        onclick="changeUnit(-1)">−</button>

                                    <input type="text" class="form-control text-center" ; id="modalUnitCount" value="1"
                                        ;maxlength="5">

                                    <button class="btn text-white" style="background:#E79901"
                                        onclick="changeUnit(1)">+</button>
                                </div>
                            </div>
                        </div>

                        <!-- TOTAL -->
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <span class="fw-semibold">Total</span>
                            <span class="fw-bold fs-5" id="modalTotalAmount"></span>
                        </div>

                        <!-- ACTION -->

                        <form id="raiseRequestForm">
                            <?php echo csrf_field(); ?>

                            <input type="hidden" name="Deal_ID" id="modalDealId">
                            <input type="hidden" name="Withdrawal_Amount" id="modalWithdrawalAmount">
                            <input type="hidden" name="Deal_Name" id="modalDealName">
                            <input type="hidden" name="Units" id="modalUnits">


                            <button type="submit"
    id="raiseRequestBtn"
    class="btn w-100 rounded-pill fw-bold text-white py-2"
    style="background:#E79901;">
    Raise Request
</button>
                        </form>


                    </div>
                </div>
            </div>
        </div>


        <!-- Bootstrap JS -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://unpkg.com/lottie-web@5.12.2/build/player/lottie.min.js"></script>

        <script>
        document.addEventListener("DOMContentLoaded", function() {

            let pricePerUnit = 0;
            let maxUnits = 1;
            let dealId = null;

            const modal = new bootstrap.Modal(document.getElementById('addUnitsModal'));
            const unitField = document.getElementById('modalUnitCount');
            const totalField = document.getElementById('modalTotalAmount');

            const hiddenDealId = document.getElementById('modalDealId');
            const hiddenAmount = document.getElementById('modalWithdrawalAmount');
            const hiddenDealName = document.getElementById('modalDealName');
            const hiddenUnits = document.getElementById('modalUnits');

            let unitPrice = 0;

            document.querySelectorAll('.openModalBtn').forEach(button => {

                button.addEventListener('click', function() {

                    dealId = this.getAttribute('data-dealid');
                    pricePerUnit = parseFloat(this.getAttribute('data-price')) || 0;
                    maxUnits = parseInt(this.getAttribute('data-maxunit')) || 1;
                    
                     unitPrice = maxUnits > 0 ? (pricePerUnit / maxUnits) : 0;

                    unitField.value = 1;
                    hiddenDealId.value = dealId;

                    let productName = this.getAttribute('data-product');

                    document.getElementById('modalProductName').innerText = productName;


                    hiddenDealName.value = productName;

                    document.getElementById('modalPricePerUnit').value =
                        '₹' + unitPrice.toLocaleString('en-IN', {
                            minimumFractionDigits: 2
                        });

                    calculateTotal();
                    modal.show();
                });
            });

            function calculateTotal() {
                
                let units = parseInt(unitField.value) || 1;
                
                    
                const total = unitPrice * units;

                totalField.innerText =
                    '₹' + total.toLocaleString('en-IN', {
                        minimumFractionDigits: 2
                    });

                hiddenAmount.value = total;
                hiddenUnits.value = units;

            }

            unitField.addEventListener('input', function() {

                this.value = this.value.replace(/[^0-9]/g, '');

                if (this.value === '') {
                    totalField.innerText = '₹0.00';
                    return;
                }

                let value = parseInt(this.value);

                if (value > maxUnits) {
                    value = maxUnits;
                    this.value = value;
                }

                calculateTotal();
            });

            unitField.addEventListener('blur', function() {

                let value = parseInt(this.value);

                if (isNaN(value) || value < 1) value = 1;
                if (value > maxUnits) value = maxUnits;

                this.value = value;
                calculateTotal();
            });

            window.changeUnit = function(change) {

                let value = parseInt(unitField.value) || 1;
                value += change;

                if (value < 1) value = 1;
                if (value > maxUnits) value = maxUnits;

                unitField.value = value;
                calculateTotal();
            };

        });
        
        const raiseForm = document.getElementById('raiseRequestForm');
const raiseBtn = document.getElementById('raiseRequestBtn');

        document.getElementById('raiseRequestForm').addEventListener('submit', function(e) {
             e.preventDefault();

    // Show processing state
    raiseBtn.disabled = true;
    raiseBtn.innerHTML = `
        <span class="spinner-border spinner-border-sm me-2"></span>
        Processing...
    `;
            let formData = new FormData(this);

            fetch("<?php echo e(route('withdrawl.raise.request')); ?>", {
                    method: "POST",
                    headers: {
                        'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                        'Accept': 'application/json'
                    },
                    body: formData
                })
                .then(response => response.json())
                
                 .then(data => {

        if (data.status === "success") {
            window.location.href = data.redirect;
        } else {
            // Reset button if failed
            raiseBtn.disabled = false;
            raiseBtn.innerHTML = "Raise Request";
            alert("Something went wrong. Please try again.");
        }

    })
    .catch(error => {
        console.error("Error:", error);

        // Reset button on error
        raiseBtn.disabled = false;
        raiseBtn.innerHTML = "Raise Request";
        alert("Server error. Please try again.");
    });
});
       
        </script>


</body>

</html><?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/investmentproductsforwithdrawl.blade.php ENDPATH**/ ?>