<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - User Details</title>
<?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <style>
      .signup-card{
        padding-top: 0;
      }
  </style>
</head>
<body>
<?php echo $__env->make('header-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 
  <section class="hero-section">
    <div class="container">
        <!-- Progress Bar -->
    <div class="text-center mb-2 fw-semibold">20% Completed</div>
    <div class="progress-container">
        <div class="progress" style="height: 6px;">
            <div class="progress-bar" style="width: 20%;"></div>
        </div>
    </div>

      <div class="row g-4 mt-4">
         <div class="col-lg-4">
             <div class="leftCard">
                <div class="avatar-box" onclick="document.getElementById('avatarInputCard').click();">
                    <img id="avatarPreviewCard" src="images/avtar.png" alt="Avatar">
                    <div class="cam-icon">📷</div>

                    <!-- Hidden File Input -->
                    <input type="file" id="avatarInputCard" accept="image/*" style="display:none" onchange="previewAvatarCard(event)">
                </div>
                <p class="accId">Account ID : Zr435T</p>
             </div>
         </div>
      <div class="col-lg-8">
          <div class="signup-card">
           
<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<form action="<?php echo e(route('zoho.contact.save')); ?>" method="POST" enctype="multipart/form-data" class="mx-auto">
<?php echo csrf_field(); ?>

<div class="row g-3 mb-2">
    <div class="col-md-6">
        <input type="text" name="first_name" class="form-control"
               value="<?php echo e(old('first_name')); ?>" placeholder="First Name">
    </div>
    <div class="col-md-6">
        <input type="text" name="last_name" class="form-control"
               value="<?php echo e(old('last_name')); ?>" placeholder="Last Name">
    </div>
</div>

<div class="mb-3">
    <input type="text" name="phone" class="form-control"
           value="<?php echo e(old('phone')); ?>" placeholder="Phone Number">
</div>

<div class="mb-3">
    <input type="email" name="email" class="form-control"
           value="<?php echo e(old('email')); ?>" placeholder="Email Id">
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Gender</label>
<div class="d-flex gap-4">
<label><input type="radio" name="gender" value="Male"
<?php echo e(old('gender','Male')=='Male'?'checked':''); ?>> Male</label>
<label><input type="radio" name="gender" value="Female"
<?php echo e(old('gender')=='Female'?'checked':''); ?>> Female</label>
<label><input type="radio" name="gender" value="Other"
<?php echo e(old('gender')=='Other'?'checked':''); ?>> Other</label>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Annual Income</label>
<div class="d-flex gap-4">
<?php $__currentLoopData = ['> 10 Cr','25 Lacs-1 Cr','10-25 Lacs','5-10 Lacs','1-5 Lacs','< 1 Lacs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<label><input type="radio" name="income" value="<?php echo e($i); ?>"
<?php echo e(old('income')==$i?'checked':''); ?>> <?php echo e($i); ?></label>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Occupation</label>
<div class="d-flex gap-4">
<?php $__currentLoopData = ['Business','Housewife','Student','Professional','Private Sector','Others']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<label><input type="radio" name="Occupation" value="<?php echo e($o); ?>"
<?php echo e(old('Occupation')==$o?'checked':''); ?>> <?php echo e($o); ?></label>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Preference for running account settlement</label>
<div class="d-flex gap-4">
<?php $__currentLoopData = ['Monthly','Quarterly','Yearly']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<label><input type="radio" name="settlement" value="<?php echo e($s); ?>"
<?php echo e(old('settlement','Monthly')==$s?'checked':''); ?>> <?php echo e($s); ?></label>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Products you like to start with</label>
<div class="d-flex gap-4">
<?php $__currentLoopData = ['Equity Shares','Preference Shares','Debentures']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<label><input type="radio" name="Products" value="<?php echo e($p); ?>"
<?php echo e(old('Products','Equity Shares')==$p?'checked':''); ?>> <?php echo e($p); ?></label>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
</div>

<h4>Nominee 1</h4>

<input type="text" class="form-control mb-2" name="nominee_name"
value="<?php echo e(old('nominee_name')); ?>" placeholder="Nominee's Name">

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_pan"
value="<?php echo e(old('nominee_pan')); ?>" placeholder="Nominee's PAN">
</div>
<div class="col-md-6">
<input type="date" class="form-control" name="nominee_dob"
value="<?php echo e(old('nominee_dob')); ?>">
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_mobile"
value="<?php echo e(old('nominee_mobile')); ?>" placeholder="Nominee's mobile">
</div>
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_email"
value="<?php echo e(old('nominee_email')); ?>" placeholder="Nominee's e-mail">
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_relation"
value="<?php echo e(old('nominee_relation')); ?>" placeholder="The nominee is my">
</div>
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_percentage"
value="<?php echo e(old('nominee_percentage')); ?>" placeholder="Percentage of share">
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Address</label>
<label><input type="radio" name="address" value="Yes"
<?php echo e(old('address','Yes')=='Yes'?'checked':''); ?>> Yes</label>
<label><input type="radio" name="address" value="No"
<?php echo e(old('address')=='No'?'checked':''); ?>> No</label>
</div>

<h4>Bank Details</h4>

<?php $__currentLoopData = ['ifsc'=>'IFSC','bank'=>'Bank','micr'=>'MICR','branch'=>'Branch','account_number'=>'Account Number','confirm_account_number'=>'Confirm Account Number']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f=>$l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<input type="text" class="form-control mb-2" name="<?php echo e($f); ?>"
value="<?php echo e(old($f)); ?>" placeholder="<?php echo e($l); ?>">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<div class="d-flex justify-content-center gap-4 mt-4">
<button type="submit" class="btn btn-otp mb-2 btn-yellow">Done</button>
</div>

</form>

          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function previewAvatar(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('avatarPreview').src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}

function previewAvatarCard(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('avatarPreviewCard').src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}
</script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\beniss\beniss\resources\views/user-profile-details.blade.php ENDPATH**/ ?>