<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Transaction Statement</title>

    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        .title {
            text-align: center;
            font-weight: bold;
            font-size: 16px;
            margin-bottom: 20px;
        }

        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .details-table td {
            padding: 6px;
            border: 1px solid #ddd;
        }

        .transaction-table {
            width: 100%;
            border-collapse: collapse;
        }

        .transaction-table th,
        .transaction-table td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: center;
        }

        .transaction-table th {
            background-color: #f2f2f2;
        }

        .text-right {
            text-align: right;
        }

        .footer {
            position: fixed;
            bottom: 10px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
        }
    </style>
</head>
<body>

<div class="title">Transaction Statement</div>

<!-- INVESTOR DETAILS -->
<table class="details-table">
    <tr>
        <td><strong>Unique Client Code</strong></td>
        <td>{{ $contact['Account_Id'] ?? '-' }}</td>
    </tr>
    <tr>
        <td><strong>Client Name</strong></td>
        <td>{{ ($contact['First_Name'] ?? '') . ' ' . ($contact['Last_Name'] ?? '') }}</td>
    </tr>
     <tr>
        <td><strong>Client Name</strong></td>
        <td>{{ $contact['Father_s_Name'] ?? '-' }}</td>
    </tr>
    <tr>
        <td><strong>PAN</strong></td>
        <td>{{ $contact['PAN'] ?? '-' }}</td>
    </tr>
    <tr>
        <td><strong>Generated On</strong></td>
        <td>{{ now()->format('d/m/Y H:i:s') }}</td>
    </tr>
</table>

<!-- TRANSACTION TABLE -->
<table class="transaction-table">
    <thead>
        <tr>
            <th>Transaction Date</th>
            <th>Settlement Date</th>
            <th>Security Type</th>
            <th>Narration</th>
            <th>Debit (Rs.)</th>
            <th>Credit (Rs.)</th>
            <th>Balance (Rs.)</th>
        </tr>
    </thead>
    <tbody>
        @forelse($transactions as $transaction)
        <tr>
            <td>{{ \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y') }}</td>
            <td>{{ \Carbon\Carbon::parse($transaction->settlement_date)->format('d-m-Y') }}</td>
            <td>{{ $transaction->security_type }}</td>
            <td>{{ $transaction->narration }}</td>
            <td class="text-right">{{ number_format($transaction->debit, 2) }}</td>
            <td class="text-right">{{ number_format($transaction->credit, 2) }}</td>
            <td class="text-right">{{ number_format($transaction->balance, 2) }}</td>
        </tr>
        @empty
        <tr>
            <td colspan="7">No transactions found</td>
        </tr>
        @endforelse
    </tbody>
</table>

<div class="footer">
    Page <span class="pagenum"></span>
</div>

</body>
</html>