<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>BeniSS Global - Dashboard</title>
    @include('head')
    <style>
    .custom-px {
        padding-left: 5.5rem;
        padding-right: 5.5rem;
    }

    .custom-py {
        padding-top: 2rem;
        padding-bottom: 2rem;
    }

    @media (max-width: 1000px) {

        .custom-px {
            padding-left: 2.5rem;
            padding-right: 2.5rem;
        }

        .WealthCard {
            margin: auto;
        }

        .WealthCardText {
            margin: auto;
        }

        .WealthCardHeading {
            text-align: center;
        }

        .WealthCardButton {
            margin: auto;
        }
        

        .tab {
            overflow-x: scroll;


        }

        .nav {
            width: max-content;
        }

        .cardHeading {
            padding-top: 8%;
        }




    }

    /* CARD GRADIENT BACKGROUND */
    .invest-card {
        border-radius: 18px;
        position: relative;
        overflow: hidden;
    }

    .invest-card-bg {
        background-image: url('{{ asset('assets/frame.png') }}');

        /* your image */
        background-repeat: no-repeat;
        background-position: right top;
        background-size: cover;
        border-radius: 1rem;
        /* matches rounded-4 */
        padding-bottom: 0;
        /* footer already handles spacing */
    }


    /* HIGH YIELD RIBBON */
    .high-yield {
        background: linear-gradient(90deg, #c6b6f5, #d8c9fb);
        color: #1b1b1b;
        font-weight: 600;
        font-size: 12px;
        padding: 10px 45px;
        border-radius: 0 0 0 14px;
        position: absolute;
        top: 0;
        right: 0;
    }

    /* BBB BADGE */
    .rating-badge {
        background: #ffffff;
        border: 1px solid #e6e6e6;
        font-weight: 600;
        padding: 6px 14px;
    }

    /* STAT BOX */
    .stat-box {
        background: rgba(255, 255, 255, 0.7);
        /* 70% opacity */
        border: 1px solid #e6edf5;
        border-radius: 10px;
        padding: 14px 12px;
        text-align: left;
    }

    /* FOOTER STRIP */
    .card-footer-strip {
        background: #062636;
        color: #ffffff;
        font-size: 13px;
        padding: 12px 104px;
        border-radius: 0 14px 0 0;
        width: fit-content;
    }

    .help-card {
        border-bottom: none
    }


    .help-card::before {
        content: "";
        position: absolute;
        inset: 0;
        padding: 1.5px;
        border-radius: inherit;
        background: linear-gradient(180deg, #E79901 0%, #FFFFFF 100%);
        -webkit-mask:
            linear-gradient(#fff 0 0) content-box,
            linear-gradient(#fff 0 0);

        mask-composite: exclude;
    }
    </style>
</head>

<body>
    @include ('header-dashboard')
    <!-- FIXED DISCOVER SECTION -->
    <section style="background:#062636; z-index:1020;">
        <div class="container pt-4">

            <!-- TITLE -->
            <h3 class="text-white text-center fw-bold mb-4">
                Discover Opportunity
            </h3>

            <!-- BUILD WEALTH CARD -->
            <div class="WealthCard bg-white rounded-4 custom-px custom-py mb-4 d-flex align-items-center justify-content-between flex-wrap"
                style=" margin-left: 5%; margin-right: 5%; ">
                <div class="WealthCardText">
                    <h4 class="WealthCardHeading fw-bold mb-1">Build Your Wealth</h4>
                    <p class="mb-0">
                        By Investing Through
                        <span class="fw-semibold text-warning">BeniSS Global</span>
                    </p>
                </div>

                <!--<button class="WealthCardButton btn rounded-pill text-white custom-px py-2 fw-bold mt-3 mt-md-0"-->
                <!--    style="background-color: #E79901;">-->
                <!--    Complete Your KYC-->
                <!--</button>-->
            </div>

            <!-- TABS -->
            <div class="tab">
                                   <ul class="nav nav-tabs border-0 flex-nowrap justify-content-between">
                        <li class="nav-item">
                            <a class="nav-link text-white px-3 fw-medium active"
                               href="#"
                               data-type="NCD">
                               NCD
                            </a>
                        </li>
                    
                        <li class="nav-item">
                            <a class="nav-link text-white px-3 fw-medium"
                               href="#"
                               data-type="CCPS">
                               CCPS
                            </a>
                        </li>
                    
                        <li class="nav-item">
                            <a class="nav-link text-white px-3 fw-medium"
                               href="#"
                               data-type="NCPS">
                               NCPS
                            </a>
                        </li>
                    
                        <li class="nav-item">
                            <a class="nav-link text-white px-3 fw-medium"
                               href="#"
                               data-type="EQUITY">
                               EQUITY
                            </a>
                        </li>
                    </ul>
            </div>

        </div>

    </section>

    <!-- SCROLLABLE CONTENT -->
    <div class="container mt-4">
        <!-- rest of page -->

        <!-- SCROLLABLE CONTENT -->
        <div class="container py-4">

            <!-- FILTERS -->
            <!--<div class="d-flex justify-content-center flex-wrap gap-2 mb-5">-->
            <!--    <button class="btn btn-sm text-white rounded-pill px-4 py-1 fw-bold" style="background:#E79901">-->
            <!--        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">-->
            <!--            <path-->
            <!--                d="M2 5.00004H5.545C5.6668 5.69533 6.02988 6.3254 6.57036 6.77944C7.11085 7.23347 7.79412 7.48237 8.5 7.48237C9.20588 7.48237 9.88916 7.23347 10.4296 6.77944C10.9701 6.3254 11.3332 5.69533 11.455 5.00004H22C22.1326 5.00004 22.2598 4.94736 22.3536 4.85359C22.4473 4.75982 22.5 4.63265 22.5 4.50004C22.5 4.36743 22.4473 4.24025 22.3536 4.14648C22.2598 4.05272 22.1326 4.00004 22 4.00004H11.455C11.3332 3.30474 10.9701 2.67467 10.4296 2.22064C9.88916 1.76661 9.20588 1.5177 8.5 1.5177C7.79412 1.5177 7.11085 1.76661 6.57036 2.22064C6.02988 2.67467 5.6668 3.30474 5.545 4.00004H2C1.86739 4.00004 1.74021 4.05272 1.64645 4.14648C1.55268 4.24025 1.5 4.36743 1.5 4.50004C1.5 4.63265 1.55268 4.75982 1.64645 4.85359C1.74021 4.94736 1.86739 5.00004 2 5.00004ZM8.5 2.50004C8.89556 2.50004 9.28224 2.61734 9.61114 2.8371C9.94004 3.05686 10.1964 3.36922 10.3478 3.73467C10.4991 4.10012 10.5387 4.50226 10.4616 4.89022C10.3844 5.27818 10.1939 5.63455 9.91421 5.91425C9.63451 6.19396 9.27814 6.38444 8.89018 6.46161C8.50222 6.53878 8.10009 6.49917 7.73463 6.3478C7.36918 6.19642 7.05682 5.94008 6.83706 5.61118C6.6173 5.28228 6.5 4.8956 6.5 4.50004C6.5 3.9696 6.71071 3.4609 7.08579 3.08582C7.46086 2.71075 7.96957 2.50004 8.5 2.50004ZM22 11.5H18.455C18.3332 10.8047 17.9701 10.1747 17.4296 9.72064C16.8892 9.26661 16.2059 9.0177 15.5 9.0177C14.7941 9.0177 14.1108 9.26661 13.5704 9.72064C13.0299 10.1747 12.6668 10.8047 12.545 11.5H2C1.86739 11.5 1.74021 11.5527 1.64645 11.6465C1.55268 11.7403 1.5 11.8674 1.5 12C1.5 12.1326 1.55268 12.2598 1.64645 12.3536C1.74021 12.4474 1.86739 12.5 2 12.5H12.545C12.6668 13.1953 13.0299 13.8254 13.5704 14.2794C14.1108 14.7335 14.7941 14.9824 15.5 14.9824C16.2059 14.9824 16.8892 14.7335 17.4296 14.2794C17.9701 13.8254 18.3332 13.1953 18.455 12.5H22C22.1326 12.5 22.2598 12.4474 22.3536 12.3536C22.4473 12.2598 22.5 12.1326 22.5 12C22.5 11.8674 22.4473 11.7403 22.3536 11.6465C22.2598 11.5527 22.1326 11.5 22 11.5ZM15.5 14C15.1044 14 14.7178 13.8827 14.3889 13.663C14.06 13.4432 13.8036 13.1309 13.6522 12.7654C13.5009 12.4 13.4613 11.9978 13.5384 11.6099C13.6156 11.2219 13.8061 10.8655 14.0858 10.5858C14.3655 10.3061 14.7219 10.1156 15.1098 10.0385C15.4978 9.9613 15.8999 10.0009 16.2654 10.1523C16.6308 10.3037 16.9432 10.56 17.1629 10.8889C17.3827 11.2178 17.5 11.6045 17.5 12C17.5 12.5305 17.2893 13.0392 16.9142 13.4143C16.5391 13.7893 16.0304 14 15.5 14ZM22 19H11.455C11.3332 18.3047 10.9701 17.6747 10.4296 17.2206C9.88916 16.7666 9.20588 16.5177 8.5 16.5177C7.79412 16.5177 7.11085 16.7666 6.57036 17.2206C6.02988 17.6747 5.6668 18.3047 5.545 19H2C1.86739 19 1.74021 19.0527 1.64645 19.1465C1.55268 19.2403 1.5 19.3674 1.5 19.5C1.5 19.6326 1.55268 19.7598 1.64645 19.8536C1.74021 19.9474 1.86739 20 2 20H5.545C5.6668 20.6953 6.02988 21.3254 6.57036 21.7794C7.11085 22.2335 7.79412 22.4824 8.5 22.4824C9.20588 22.4824 9.88916 22.2335 10.4296 21.7794C10.9701 21.3254 11.3332 20.6953 11.455 20H22C22.1326 20 22.2598 19.9474 22.3536 19.8536C22.4473 19.7598 22.5 19.6326 22.5 19.5C22.5 19.3674 22.4473 19.2403 22.3536 19.1465C22.2598 19.0527 22.1326 19 22 19ZM8.5 21.5C8.10444 21.5 7.71776 21.3827 7.38886 21.163C7.05996 20.9432 6.80362 20.6309 6.65224 20.2654C6.50087 19.9 6.46126 19.4978 6.53843 19.1099C6.6156 18.7219 6.80608 18.3655 7.08579 18.0858C7.36549 17.8061 7.72186 17.6156 8.10982 17.5385C8.49778 17.4613 8.89991 17.5009 9.26537 17.6523C9.63082 17.8037 9.94318 18.06 10.1629 18.3889C10.3827 18.7178 10.5 19.1045 10.5 19.5C10.5 20.0305 10.2893 20.5392 9.91421 20.9142C9.53914 21.2893 9.03043 21.5 8.5 21.5Z"-->
            <!--                fill="white" />-->
            <!--        </svg>-->
            <!--        Filter-->
            <!--    </button>-->
            <!--    <button class="btn btn-sm bg-light  rounded-pill px-4 py-1 fw-bold">-->
            <!--        sort by-->
            <!--    </button>-->
            <!--    <button class="btn btn-sm bg-light  rounded-pill px-4 py-1 fw-bold">-->
            <!--        yield &gt; 12%-->
            <!--    </button>-->
            <!--    <button class="btn btn-sm bg-light  rounded-pill px-4 py-1 fw-bold">-->
            <!--        Tenure â‰¥ 1 year-->
            <!--    </button>-->
            <!--</div>-->
            
            @if(session('error'))
    <div class="alert alert-warning">
        {{ session('error') }}
    </div>
@endif

            <!-- INVESTMENT CARD -->
            @foreach($products as $product)
  <div class="card border-0 shadow-sm mb-4 invest-card "
               
                 data-product-id="{{ $product['product_id'] }}"
        data-product-name="{{ $product['product_name'] }}"
        data-security-type="{{ $product['security_type'] }}"
        data-frequency="{{ $product['Frequency'] }}"
        data-min-investment="{{ $product['minimum_investment'] }}"
                >
    <div class="invest-card-bg">

        <!-- HIGH YIELD RIBBON -->
        @if($product['rate_of_interest'] >= 12)
            <div class="high-yield">High Yield</div>
        @endif

        <!-- HEADER -->
        <div class="cardHeading d-flex justify-content-between align-items-start mb-4"
             style="margin-top:5%; padding-right:8%;">
            <div class="d-flex align-items-center gap-3 px-5">
                 <img src="{{ route('product.photo', $product['product_id']) }}" width="70" />
                <h6 class="fw-bold mb-0">
                    {{ $product['product_name'] }}
                </h6>
            </div>

            <span class="badge rating-badge rounded-pill text-dark fw-bold">
                BBB+
            </span>
        </div>

        <!-- STATS -->
        <div class="row g-3 px-5 mb-3">
            <div class="col-md-4">
                <div class="stat-box">
                    <h6 class="fw-bold mb-1">
                        {{ $product['rate_of_interest'] }} %
                    </h6>
                    <small class="text-muted">YIELD</small>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-box">
                    <h6 class="fw-bold mb-1">
                        {{ $product['tenure_in_month'] ." Months" }}
                    </h6>
                    <small class="text-muted">TENURE</small>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-box">
                    <h6 class="fw-bold mb-1">
                        {{ number_format($product['minimum_investment']) }}
                    </h6>
                    <small class="text-muted">MIN. INVEST.</small>
                </div>
            </div>
        </div>
        
        <!-- CTA BUTTON -->
                    <div class="text-center my-4">
                        <button class="btn text-white fw-semibold px-5 py-2 rounded-pill"
                                style="background:#E79901" 
                                data-bs-toggle="modal"
                                data-bs-target="#addUnitsModal"
                                onclick="event.stopPropagation();">
                            Raise a Request
                        </button>
                    </div>

        <!-- FOOTER STRIP -->
        <div class="card-footer-strip">
            Interest Monthly &nbsp;|&nbsp; Principal At Maturity
        </div>

    </div>
</div>
@endforeach

<div class="d-flex justify-content-left mt-4">
   {{ $products->onEachSide(2)->links('pagination::bootstrap-5') }}
</div>


            <!-- HELP SECTION -->
            <div class="card rounded-4 help-card">
                <div class="card-body p-4">

                    <!-- TITLE -->
                    <h4 class="fw-bold mb-2">
                        Need Help in Finding The Right Opportunity ?
                    </h4>

                    <!-- SUBTEXT -->
                    <p class="mb-4 text-dark">
                        Consult with your Relationship Manager and get required assistance
                    </p>

                    <div class="d-flex align-items-center row">

                        <!-- RM INFO -->
                        <div class="d-flex align-items-center gap-3 mb-3">
                            <img src="{{asset('assets/companyLogo.png')}}" width="44" alt="RM">

                            <div>
                                <h6 class="fw-bold mb-1">Ramesh Kumar</h6>
                                <small class="text-muted">
                                    Available 09:30 AM to 7:30 PM, Mon to Fri.
                                </small>
                            </div>
                        </div>

                        <!-- ACTIONS -->
                        <div class="d-flex 
            flex-column flex-md-row 
            align-items-start align-items-md-center 
            gap-3 mt-4 mt-md-0">

                            <!-- Book Consultation Button -->
                            <button class="btn rounded-pill fw-semibold text-white w-100 w-md-auto px-4 py-2"
                                style="background-color: #A51E21">
                                Book a Consultation
                            </button>

                            <!-- Action Buttons -->
                            <div class="d-flex align-items-center gap-2 w-100 w-md-auto">

                                <!-- Call Button -->
                                <button class="btn rounded-circle d-flex align-items-center justify-content-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40"
                                        fill="none">
                                        <rect width="39.9877" height="39.9274" rx="19.9637" fill="#002233" />
                                        <path
                                            d="M27.4077 21C27.1877 21 26.9577 20.93 26.7377 20.88C26.2926 20.7805 25.8548 20.6501 25.4277 20.49C24.9638 20.3212 24.4539 20.33 23.996 20.5146C23.5382 20.6992 23.1648 21.0466 22.9477 21.49L22.7277 21.95C21.7566 21.3992 20.8594 20.7271 20.0577 19.95C19.2806 19.1484 18.6085 18.2512 18.0577 17.28L18.5177 17.07C18.9611 16.8529 19.3085 16.4795 19.4931 16.0217C19.6777 15.5639 19.6865 15.0539 19.5177 14.59C19.3589 14.159 19.2286 13.7181 19.1277 13.27C19.0777 13.05 19.0377 12.82 19.0077 12.6C18.8863 11.8956 18.5174 11.2577 17.9674 10.8012C17.4173 10.3447 16.7224 10.0996 16.0077 10.11H12.9977C12.575 10.1094 12.1569 10.1982 11.7708 10.3706C11.3848 10.5429 11.0396 10.7949 10.7577 11.11C10.4701 11.4337 10.2558 11.8158 10.1298 12.23C10.0038 12.6443 9.96899 13.081 10.0277 13.51C10.5713 17.6721 12.4729 21.5387 15.4377 24.51C18.4091 27.4748 22.2756 29.3764 26.4377 29.92C26.5675 29.9299 26.6979 29.9299 26.8277 29.92C27.5651 29.9211 28.2771 29.6505 28.8277 29.16C29.1428 28.8782 29.3948 28.5329 29.5671 28.1469C29.7395 27.7609 29.8283 27.3428 29.8277 26.92V23.92C29.8223 23.229 29.5786 22.5611 29.1377 22.0291C28.6967 21.4971 28.0857 21.1336 27.4077 21ZM27.8977 27C27.8974 27.1395 27.8679 27.2775 27.811 27.4049C27.7542 27.5324 27.6713 27.6465 27.5677 27.74C27.4581 27.8399 27.3277 27.9141 27.1859 27.9573C27.0441 28.0006 26.8944 28.0117 26.7477 27.99C23.016 27.5026 19.548 25.802 16.8777 23.15C14.2052 20.4775 12.4898 16.9974 11.9977 13.25C11.976 13.1033 11.9872 12.9537 12.0304 12.8119C12.0736 12.67 12.1479 12.5396 12.2477 12.43C12.3424 12.3252 12.4581 12.2415 12.5874 12.1847C12.7167 12.1278 12.8565 12.0989 12.9977 12.1H15.9977C16.2289 12.0944 16.4549 12.169 16.6372 12.3112C16.8195 12.4534 16.9469 12.6544 16.9977 12.88C16.9977 13.15 17.0877 13.43 17.1477 13.7C17.2633 14.2239 17.417 14.7386 17.6077 15.24L16.2077 15.9C15.9671 16.0105 15.7801 16.2119 15.6877 16.46C15.5877 16.7035 15.5877 16.9765 15.6877 17.22C17.1269 20.3028 19.605 22.7808 22.6877 24.22C22.9312 24.32 23.2043 24.32 23.4477 24.22C23.6959 24.1276 23.8973 23.9406 24.0077 23.7L24.6377 22.3C25.1536 22.4881 25.6815 22.6418 26.2177 22.76C26.4777 22.82 26.7577 22.87 27.0277 22.91C27.2533 22.9608 27.4543 23.0882 27.5965 23.2705C27.7387 23.4529 27.8134 23.6788 27.8077 23.91L27.8977 27ZM21.9977 10C21.7677 10 21.5277 10 21.2977 10C21.0325 10.0225 20.7871 10.1495 20.6155 10.353C20.4439 10.5565 20.3602 10.8198 20.3827 11.085C20.4053 11.3502 20.5323 11.5956 20.7357 11.7672C20.9392 11.9388 21.2025 12.0225 21.4677 12H21.9977C23.589 12 25.1152 12.6321 26.2404 13.7574C27.3656 14.8826 27.9977 16.4087 27.9977 18C27.9977 18.18 27.9977 18.35 27.9977 18.53C27.9756 18.7938 28.0589 19.0556 28.2295 19.2581C28.4001 19.4606 28.644 19.5871 28.9077 19.61H28.9877C29.2381 19.611 29.4797 19.5181 29.6648 19.3496C29.85 19.1811 29.9652 18.9493 29.9877 18.7C29.9877 18.47 29.9877 18.23 29.9877 18C29.9877 15.88 29.1462 13.8467 27.6481 12.3467C26.15 10.8467 24.1177 10.0027 21.9977 10ZM23.9977 18C23.9977 18.2652 24.1031 18.5196 24.2906 18.7071C24.4782 18.8946 24.7325 19 24.9977 19C25.2629 19 25.5173 18.8946 25.7048 18.7071C25.8924 18.5196 25.9977 18.2652 25.9977 18C25.9977 16.9391 25.5763 15.9217 24.8262 15.1716C24.076 14.4214 23.0586 14 21.9977 14C21.7325 14 21.4782 14.1054 21.2906 14.2929C21.1031 14.4804 20.9977 14.7348 20.9977 15C20.9977 15.2652 21.1031 15.5196 21.2906 15.7071C21.4782 15.8946 21.7325 16 21.9977 16C22.5282 16 23.0369 16.2107 23.4119 16.5858C23.787 16.9609 23.9977 17.4696 23.9977 18Z"
                                            fill="white" />
                                    </svg>
                                </button>

                                <!-- WhatsApp Button -->
                                <button
                                    class="btn btn-success rounded-circle d-flex align-items-center justify-content-center"
                                    style="width: 42px; height: 42px;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="44" height="44" viewBox="0 0 44 44"
                                        fill="none">
                                        <g clip-path="url(#clip0_179_6489)">
                                            <path
                                                d="M37.5867 6.3941C33.4505 2.27321 27.9505 0.00251425 22.0906 0C10.0155 0 0.188753 9.78037 0.183919 21.8018C0.182512 25.6446 1.191 29.3956 3.10786 32.7021L0 44L11.613 40.9683C14.8126 42.7056 18.4151 43.621 22.0812 43.6225H22.0905H22.0906C34.1638 43.6225 43.992 33.8404 43.9972 21.8195C43.9992 15.9933 41.7225 10.5153 37.5867 6.3941ZM22.0906 39.9401H22.0835C18.8158 39.9384 15.6113 39.0649 12.8162 37.4137L12.151 37.0211L5.25965 38.82L7.09956 32.1329L6.66617 31.4473C4.8434 28.5618 3.88112 25.2273 3.8825 21.8032C3.8865 11.8114 12.0541 3.68255 22.0975 3.68255C26.9611 3.68457 31.5322 5.57198 34.9702 8.99715C38.4079 12.4223 40.2997 16.9755 40.2982 21.818C40.294 31.8101 32.1261 39.9401 22.0906 39.9401Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M1.00684 42.7465L3.97254 31.9647C2.14289 28.8092 1.18071 25.2292 1.18187 21.5628C1.18667 10.0907 10.564 0.757324 22.0858 0.757324C27.6779 0.759838 32.9264 2.92669 36.8726 6.85945C40.8196 10.7922 42.992 16.0196 42.9897 21.579C42.9849 33.0514 33.607 42.3856 22.0866 42.3856C22.0858 42.3856 22.0872 42.3856 22.0866 42.3856H22.0773C18.579 42.3845 15.1415 41.5101 12.0884 39.8534L1.00684 42.7465Z"
                                                fill="url(#paint0_linear_179_6489)" />
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M16.6779 12.546C16.2726 11.6488 15.8459 11.6309 15.4603 11.6152C15.145 11.6017 14.784 11.6025 14.4235 11.6025C14.0628 11.6025 13.4765 11.7375 12.9808 12.2766C12.4848 12.8156 11.0869 14.1188 11.0869 16.7691C11.0869 19.4198 13.0259 21.9809 13.2962 22.3406C13.5667 22.6998 17.0392 28.3125 22.5385 30.4718C27.109 32.2663 28.039 31.9093 29.0311 31.8196C30.0231 31.7298 32.2321 30.5167 32.683 29.2587C33.1339 28.001 33.1339 26.9229 32.9987 26.6976C32.8634 26.4731 32.5026 26.3384 31.9615 26.069C31.4204 25.7996 28.7605 24.4962 28.2645 24.3166C27.7685 24.137 27.4077 24.0472 27.047 24.5866C26.6862 25.1254 25.6499 26.3384 25.3343 26.6976C25.0186 27.0576 24.703 27.1025 24.1619 26.8331C23.6207 26.5629 21.8782 25.9946 19.811 24.1594C18.2026 22.7317 17.1167 20.9684 16.801 20.429C16.4854 19.8903 16.7672 19.5984 17.0386 19.3299C17.2815 19.0886 17.5797 18.701 17.8503 18.3865C18.1202 18.0719 18.2104 17.8474 18.3908 17.4882C18.5712 17.1285 18.481 16.8139 18.3457 16.5446C18.2104 16.2752 17.1589 13.6111 16.6779 12.546Z"
                                                fill="white" />
                                            <path
                                                d="M37.4068 6.32487C33.3182 2.25128 27.8817 0.00670056 22.0896 0.00415039C10.1538 0.00415039 0.440483 9.67224 0.435685 21.5557C0.434278 25.3544 1.43112 29.0623 3.32585 32.3308L0.253906 43.499L11.7329 40.5021C14.8956 42.2194 18.4565 43.1244 22.0803 43.1258H22.0895H22.0896C34.0234 43.1258 43.7381 33.456 43.7432 21.5731C43.7452 15.8139 41.4947 10.3988 37.4068 6.32487ZM22.0896 39.4858H22.0825C18.8525 39.4841 15.685 38.6207 12.9222 36.9884L12.2647 36.6003L5.45283 38.3785L7.27148 31.7682L6.84309 31.0906C5.04136 28.2382 4.09019 24.9418 4.0916 21.5572C4.09553 11.68 12.1688 3.6445 22.0964 3.6445C26.9038 3.64648 31.4221 5.51223 34.8204 8.89807C38.2185 12.2839 40.0884 16.7848 40.087 21.5718C40.0827 31.4492 32.0091 39.4858 22.0896 39.4858Z"
                                                fill="white" />
                                        </g>
                                        <defs>
                                            <linearGradient id="paint0_linear_179_6489" x1="21.9983" y1="42.7465"
                                                x2="21.9983" y2="0.757394" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#20B038" />
                                                <stop offset="1" stop-color="#60D66A" />
                                            </linearGradient>
                                            <clipPath id="clip0_179_6489">
                                                <rect width="43.9972" height="44" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </button>

                            </div>
                        </div>


                    </div>

                </div>
            </div>


        </div>

    </div>
    <footer>
        <img src="{{asset('assets/iso.png')}}">
        <span class="isoText">ISO 27001 Certified</span>
    </footer>

    <!-- ADD UNITS MODAL -->
<div class="modal fade" id="addUnitsModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 overflow-hidden">

            <!-- HEADER -->
            <div class="modal-header border-0 text-white"
                style="background:#062636;">
                <h5 class="modal-title">Add Units</h5>
                <button type="button" class="btn-close btn-close-white"
                    data-bs-dismiss="modal"></button>
            </div>

            <!-- BODY -->
            <div class="modal-body p-4">

                <!-- LOGO -->
                <div class="text-center ">
                    <img src="{{asset('assets/companyLogo.png')}}" width="70">
                </div>

                <!-- COMPANY NAME -->
                <h6 class="text-center fw-bold" id="modalProductName">
                    
                </h6>

                <!-- PRICE + UNITS -->
                <div class="row g-3 mb-3">
                    <div class="col-6">
                        <label class="form-label fw-semibold">Per lot amount</label>
                        <input type="text" class="form-control"
       id="pricePerUnit"
       readonly>

                    </div>

                    <div class="col-6">
                        <label class="form-label fw-semibold">Number of lot</label>
                        <div class="input-group">
                            <button class="btn btn-warning text-white"
                                onclick="changeUnit(-1)">-</button>

                            <input type="text" class="form-control text-center"
                                id="unitCount" value="1">

                            <button class="btn btn-warning text-white"
                                onclick="changeUnit(1)">+</button>
                        </div>
                    </div>
                </div>

                <!-- TOTAL -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <span class="fw-semibold">Total</span>
                    <span class="fw-bold fs-5" id="totalAmount"></span>
                </div>

                <!-- ACTION -->
                <form id="raiseRequestForm">
    @csrf

    <input type="hidden" name="product_id" id="productId">
    <input type="hidden" name="security_type" id="securityType">
    <input type="hidden" name="frequency" id="frequency">
    <input type="hidden" name="unit" id="unitInput">
    <input type="hidden" name="total_amount" id="totalAmountInput">
     <input type="hidden" name="product_name" id="product_name">

    <button id="raiseBtn" class="btn w-100 rounded-pill fw-bold text-white py-2"
            style="background:#E79901;">
        Raise Request
    </button>
</form>


            </div>
        </div>
    </div>
</div>



    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
let pricePerUnit = 0;
let unitCount = 1;

document.getElementById('addUnitsModal')
.addEventListener('show.bs.modal', function (event) {

    const button = event.relatedTarget;

    // ðŸ”¥ FIX: get parent card
    const card = button.closest('.invest-card');

    const productId     = card.dataset.productId;
    const productName   = card.dataset.productName;
    const securityType  = card.dataset.securityType;
    const frequency     = card.dataset.frequency;
    pricePerUnit        = parseFloat(card.dataset.minInvestment) || 0;

    unitCount = 1;
    const total = pricePerUnit * unitCount;

    // Hidden fields
    document.getElementById('productId').value = productId;
    document.getElementById('securityType').value = securityType;
    document.getElementById('frequency').value = frequency;
    document.getElementById('unitInput').value = unitCount;
    document.getElementById('totalAmountInput').value = total;
    document.getElementById('product_name').value = productName;

    // UI fields
    document.getElementById('modalProductName').innerText = productName;
    document.getElementById('unitCount').value = unitCount;

    document.getElementById('pricePerUnit').value =
         '₹' + pricePerUnit.toLocaleString('en-IN');

    document.getElementById('totalAmount').innerText =
         '₹' + total.toLocaleString('en-IN', { minimumFractionDigits: 2 });
});


// + / âˆ’ buttons
function changeUnit(value) {
    unitCount += value;
    if (unitCount < 1) unitCount = 1;

    const total = pricePerUnit * unitCount;

    document.getElementById('unitCount').value = unitCount;
    document.getElementById('totalAmount').innerText =
         '₹' + total.toLocaleString('en-IN', { minimumFractionDigits: 2 });

    // Keep hidden fields in sync
    document.getElementById('unitInput').value = unitCount;
    document.getElementById('totalAmountInput').value = total;
}

// Nav tab active handling
document.querySelectorAll('.nav-link').forEach(tab => {
    tab.addEventListener('click', function () {
        document.querySelectorAll('.nav-link')
            .forEach(t => t.classList.remove('active', 'bg-white', 'text-dark'));

        this.classList.add('active', 'bg-white', 'text-dark');
    });
});
</script>
<script>
const unitField = document.getElementById('unitCount');

unitField.addEventListener('input', function () {
     this.value = this.value.replace(/[^0-9]/g, '');

    // Allow empty while typing
    if (this.value === '') {
        document.getElementById('totalAmount').innerText = '₹0.00';
        document.getElementById('unitInput').value = '';
        document.getElementById('totalAmountInput').value = '';
        return;
    }

    let value = parseInt(this.value);

    if (!isNaN(value)) {

        const total = pricePerUnit * value;

        document.getElementById('unitInput').value = value;

        document.getElementById('totalAmount').innerText =
            '₹' + total.toLocaleString('en-IN', { minimumFractionDigits: 2 });

        document.getElementById('totalAmountInput').value = total;
    }
});

// Enforce minimum only when user leaves field
unitField.addEventListener('blur', function () {

    let value = parseInt(this.value);

    if (isNaN(value) || value < 1) {
        this.value = 1;

        const total = pricePerUnit * 1;

        document.getElementById('unitInput').value = 1;
        document.getElementById('totalAmount').innerText =
            '₹' + total.toLocaleString('en-IN', { minimumFractionDigits: 2 });
        document.getElementById('totalAmountInput').value = total;
    }
});
</script>
    
   <script>
document.getElementById('raiseRequestForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const form = this;
    const button = document.getElementById('raiseBtn');

    // UX feedback 🚀
    button.disabled = true;
    button.innerHTML = 'Processing... <span class="spinner-border spinner-border-sm ms-2"></span>';

    let formData = new FormData(form);

    fetch("{{ route('investment.raise.request') }}", {
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': "{{ csrf_token() }}",
            'Accept': 'application/json'
        },
        body: formData
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'success') {
            window.location.href = data.redirect;
        } else {
            alert(data.message);
            resetButton();
        }
    })
    .catch(err => {
        console.error(err);
        alert('Something went wrong. Please try again.');
        resetButton();
    });

    function resetButton() {
        button.disabled = false;
        button.innerHTML = 'Raise Request';
    }
});
</script>

<script>
document.querySelectorAll('.nav-link').forEach(tab => {
    tab.addEventListener('click', function (e) {
         

        const selectedType = this.dataset.type;

        // Active tab styling
        document.querySelectorAll('.nav-link').forEach(t =>
            t.classList.remove('active', 'bg-white', 'text-dark')
        );
        this.classList.add('active', 'bg-white', 'text-dark');

        // Filter cards
        document.querySelectorAll('.invest-card').forEach(card => {
            const cardType = card.dataset.securityType;

            if (cardType === selectedType) {
                card.style.display = 'block';
            } else {
                card.style.display = 'none';
            }
        });
    });
});
</script>


</body>

</html>