<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8" />
      <title>BeniSS Global - Dashboard</title>
 @include('head')
      <style>
         .stats-wrap {
  position: relative;
  background: #ffffff;
  border-radius: 20px;
  padding: 28px 32px;
}
         .stats-wrap::before {
  content: "";
  position: absolute;
  inset: 0;
  padding: 5px; /* border thickness */
  border-radius: 20px;
 background: linear-gradient(45deg, #e79a01ca 0%, #FFFFFF, #FFFFFF, #FFFFFF, #FFFFFF, #e79a01ca 100%);
  -webkit-mask:
    linear-gradient(#fff 0 0) content-box,
    linear-gradient(#fff 0 0);
  -webkit-mask-composite: xor;
          mask-composite: exclude;
  pointer-events: none;
}
      </style>
   </head>
   <body>
      @include ('header-dashboard')
      <section class="hero-section">
         <div class="container">
            <div class="row g-4 align-items-center">
               <!-- Right side: signup form -->
               <div class="col-lg-12 ms-lg-auto">
                  <div class="signup-card">
                     <h3 class="text-center fw-bold">Hey {{ auth()->user()->first_name }} !</h3>
                     <p class="text-center" style="margin: 0; font-size: 1.3em; color: #71717A">
                        here’s what’s happening till today
                     </p>
                     <div class="container stats-wrap mt-4">
                        <div class="row g-3">
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <h6 class="fw-bold">TOTAL AMOUNT INVESTED</small>
                                 <h5 class="fw-bold">
                                     ₹{{ $credit_principal ?? 0 }}
                                     <!--<span style="font-weight: bold;">₹0</span>-->
                                 </h5>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <h6 class="fw-bold">TOTAL AMOUNT WITHDRAWAL</h6>
                                 <h5 class="fw-bold">₹{{ $Total_Withdrawl ?? 0 }}
                                    <!--<span>₹0</span>-->
                                 </h5>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <h6 class="fw-bold">NET PORTFOLIO VALUE</h6>
                                 <h5 class="fw-bold">₹{{ $Net_portfolio_value ?? 0 }}
                                     <!--<span style="font-weight: bold;">₹0</span>-->
                                    
                                 </h5>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <h6 class="fw-bold">TOTAL RETURN</h6>
                                 <h5 class="fw-bold">
                                    ₹{{ $Total_Return_Earned ?? 0 }}
                                     <!--<span style="font-weight: bold;">₹0</span>-->
                                 </h5>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <h6 class="fw-bold">Return Received</h6>
                                 <h5 class="fw-bold">
                                    ₹{{ $Return_Received ?? 0  }}
                                     <!--<span style="font-weight: bold;">₹0</span>-->
                                 </h5>
                              </div>
                           </div>
                           <div class="col-md-4">
                              <div class="stats-card">
                                 <h6 class="fw-bold">Return Receivable</h6>
                                 <h5 class="fw-bold">
                                    ₹{{ $Return_Receivable ?? 0  }}
                                     <!--<span style="font-weight: bold;">₹0</span>-->
                                 </h5>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               
               @if (session('error'))
    <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif
               <div class="col-lg-12 ms-lg-auto">
                  <h3 class="fw-bold">Explore BeniSS</h3>
                  <div class="row g-3 mt-3">
                     <div class="col-md-3">
                       <div class="explore-box" onclick="window.location.href='{{ route('investmentform') }}'">
                            <span class="icon-exp">⚡</span>
                            <h5>Investment</h5>
                        </div>


                     </div>
                     <div class="col-md-3">
                        <div class="explore-box" onclick="window.location.href='{{ route('withdrawlform') }}'">
                           <span class="icon-exp">⚡</span> 
                           <h5>Withdrawal</h5>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <h5>Insurance</h5>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <h5>Units</h5>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                   <h3 class="mt-3 fw-bold">Sponsored Products</h3>
                  <div class="big-box mt-3"></div>
                  <div class="bottom-strip fw-bold">Line Related to ad</div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                   <h3 class="fw-bold mt-3">What’s New ?</h3>
                  <div class="row g-3 mt-3">
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                            <span class="row">
                                    <h5>Marketing & Communication</h5>
                                    <span class="time">2 Days Ago</span>
                             </span>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                            <span class="row">
                                    <h5>Marketing & Communication</h5>
                                    <span class="time">2 Days Ago</span>
                                </span>
                        </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                           <span class="row">
                                    <h5>Marketing & Communication</h5>
                                    <span class="time">2 Days Ago</span>
                            </span>                       
			 </div>
                     </div>
                     <div class="col-md-3">
                        <div class="explore-box">
                           <span class="icon-exp">⚡</span> 
                            <span class="row">
                                    <h5>Marketing & Communication</h5>
                                    <span class="time">2 Days Ago</span>
                                </span>                      
			  </div>
                     </div>
                  </div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                   <h3 class="fw-bold">Continue Where You Left </h3>
                  <div class="big-box mt-3"></div>
                  <div class="bottom-strip fw-bold">Line Related to ad</div>
               </div>
               <div class="col-lg-12 ms-lg-auto">
                  <div id="wealthSlider" class="carousel slide" data-bs-ride="carousel">
    <div class="carousel-inner">

        <!-- Slide 1 -->
 <h3 class="fw-bold mt-2">Explore Investments</h3>
        <div class="carousel-item active mt-3">
            <div class="wealth-card">
                <div class="wealth-content">
                    <div class="row align-items-center">
                        <div class="col-md-7">
                            <div class="wealth-title">Build Your Wealth</div>
                            <div class="wealth-subtitle">
                                By Investing Through <span>BeniSS Global</span>
                            </div>
                        </div>
                        <div class="col-md-5 text-end wealth-image">
                            <img src="{{asset('assets/financial.png')}}" alt="Wealth">
                        </div>
                    </div>
                </div>
                <div class="wealth-footer">
                    25 Lakhs+ Users Invest in BeniSS Global
                </div>
            </div>
        </div>

        <!-- Slide 2 -->
        <div class="carousel-item">
            <div class="wealth-card">
                <div class="wealth-content">
                    <div class="row align-items-center">
                        <div class="col-md-7">
                            <div class="wealth-title">Secure Your Future</div>
                            <div class="wealth-subtitle">
                                With <span>BeniSS Global</span>
                            </div>
                        </div>
                        <div class="col-md-5 text-end wealth-image">
                            <img src="{{asset('assets/financial.png')}}" alt="Wealth">
                        </div>
                    </div>
                </div>
                <div class="wealth-footer">
                    Trusted by Millions of Investors
                </div>
            </div>
        </div>

    </div>

    <!-- Controls -->
    <button class="carousel-control-prev" type="button" data-bs-target="#wealthSlider" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#wealthSlider" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
    </button>
</div>
               </div>      <div class="col-lg-12 ms-lg-auto">
                    <h3 class="fw-bold">BeniSS Global Loan Terms</h3>
                    <div class="listLoan">
                        <div class="d-flex justify-content-between align-items-center" style="line-height: 2.5em;">
                            <div>
                                <h4>Cash Loan</h4>
                                <ul>
                                    <li>Loan Amount Up to <b>₹ 20,00,000</b></li>
                                    <li>Loan Tenure Up to 84 Months</li>
                                    <li>Interest Rates Range From 12.06% to 29.96%</li>
                                </ul>
                            </div>

                            <div class="col-md-5 text-end wealth-image">
                                <img src="{{asset('assets/financial.png')}}" alt="Wealth">
                            </div>
                        </div>
                        <a href="#">Know More</a>
                    </div>

                    <div class="listLoan">
                        <div class="d-flex justify-content-between align-items-center" style="line-height: 2.5em;">
                            <div>
                                <h4>MSME Loan</h4>
                                <ul>
                                    <li>Loan Amount Up to <b>₹ 20,00,000</b></li>
                                    <li>Loan Tenure Up to 84 Months</li>
                                    <li>Interest Rates Range From 12.06% to 29.96%</li>
                                </ul>
                            </div>

                            <div class="col-md-5 text-end wealth-image">
                                <img src="{{asset('assets/financial.png')}}" alt="Wealth">
                            </div>
                        </div>
                        <a href="#">Know More</a>
                    </div>
                </div>
            </div>
         </div>
      </section>

      <footer>
        <img src="{{asset('assets/iso.png')}}">
        <span class="isoText">ISO 27001 Certified</span>
      </footer>
      <!-- Bootstrap JS -->
      <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
   </body>
</html>