<?php

/**
 * Zoho Crm Api Trait Class
 * To access the common functions
 *
 * @package    Laravel
 * @subpackage App\Http\Controllers\Traits
 */

namespace App\Traits;


// use \Session as session;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use Exception;

trait ZohoCrmTrait {

    //protected $zohoUrl = 'https://crmsandbox.zoho.in/crm/v2/';
    protected $zohoUrl ='https://www.zohoapis.in/crm/v8/';
    
       public function getAccessToken() {
        /* New Production Account */
           $crm_config = array(
            'client_id' => '1000.AOTLKQJ7I46N6OG6K12WLMHWF5H01X',
            'client_secret' => '337262563cd13d9744b9df897bc638721ec6dd6d27',
            'refresh_token' => '1000.e12619dfdd773d60bc3e95d548af9a6e.3f1cc788a1d4fc4e19b52f752c46280a',
            'grant_type' => 'refresh_token',
            'api_url' => 'https://www.zohoapis.in/crm/v8/',
            'account_domain' => 'https://accounts.zoho.in/',
           );

        /* End Production */

       $zoho_crm_session = Session::get('zoho_crm');
    $current_time = date('Y-m-d H:i:s');

    if (isset($zoho_crm_session->access_token) && ($current_time < $zoho_crm_session->expiring_at)) {
        return Session::get('zoho_crm');
    } else {
        $url = $crm_config['account_domain'] . 'oauth/v2/token';

        $postData = [
            'client_id' => $crm_config['client_id'],
            'client_secret' => $crm_config['client_secret'],
            'refresh_token' => $crm_config['refresh_token'],
            'grant_type' => $crm_config['grant_type']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, FALSE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);

        $response = curl_exec($ch);
        $response = json_decode($response);

        if (isset($response->access_token)) {
            $now = time();
            $ten_minutes = $now + (20 * 60);
            $endDate = date('Y-m-d H:i:s', $ten_minutes);

            $response->expiring_at = $endDate;
            Session::put('zoho_crm', $response);

           

            return $response;
        } else {
            throw new UnexpectedValueException("Error Processing Request", 1);
        }
    }
}

    public function getAllUsers() {
        $url = 'users?type=AllUsers';
        return $this->sendGetRequest($url);
    }

    public function getZohoCrmRecordsList($module) {
        $url = $module;
        return $this->sendGetRequest($url);
    }

    public function getZohoCrmSpecificRecords($module, $recordId) {
        $url = $module . '/' . $recordId;
        // $url = $module . '/search?criteria=(Sales_System_Opportunity:equals:'.$recordId.')';
        return $this->sendGetRequest($url);
    }

    public function getZohoCrmActiveUsers() {
        $url = 'users?type=ActiveUsers';
        return $this->sendGetRequest($url);
    }

    public function createZohoCrmRecord($module, $postData) {
        $url = $module;
        return $this->sendPostRequest($url, $postData);
    }
    
    

    public function updateZohoCrmRecord($module, $recirdId, $postData) {
        $url = $module . '/' . $recirdId;
       
        return $this->sendPutRequest($url, $postData);
    }

    public function updateZohoCrmRecordPhoto($module, $recordId, $filePath)
{
    $url = "{$module}/{$recordId}/photo?restrict_triggers=workflow"; 

    return $this->sendPhotoUploadRequest($url, $filePath);
}

    public function searchRecords($module,$criteria){
        $url = $module.'/search?'.$criteria;
    
        return $this->sendGetRequest($url);
    }
    
     public function searchRecordsProducts($module,$criteria){
        $url = $module.'/search?criteria='.urlencode($criteria);
    
        return $this->sendGetRequest($url);
    }
    
     public function searchRecordsbyrecordid($module,$recordid){
        $url = $module.'/'.$recordid;
        
        return $this->sendGetRequest($url);
    }
    
    public function getFileByFileId($id)
{
    $url = "https://www.zohoapis.in/crm/v8/files?id={$id}";
    

    $credentials = $this->getAccessToken();

    if (!isset($credentials->access_token)) {
        throw new \Exception('Zoho access token missing');
    }

    $headers = [
        'Authorization: Zoho-oauthtoken ' . $credentials->access_token
    ];

    $ch = curl_init();

    curl_setopt_array($ch, [
        CURLOPT_URL            => $url,
        CURLOPT_HTTPGET        => true,
        CURLOPT_HTTPHEADER     => $headers,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_HEADER         => true, // IMPORTANT
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new \Exception(curl_error($ch));
    }

    $headerSize  = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);

    $body = substr($response, $headerSize);

    curl_close($ch);

    return [
        'content' => $body,
        'type'    => $contentType
    ];
}
    
    
    
     public function uploadZohoCrmRecordAttachment($module, $id, $absoluteFilePath)
  {
    $url = "https://www.zohoapis.in/crm/v8/{$module}/{$id}/Attachments";
    $credentials = $this->getAccessToken();
    if (!isset($credentials->access_token)) {
        throw new \Exception('Zoho access token missing');
    }

    if (!file_exists($absoluteFilePath)) {
        throw new \Exception('Attachment file not found');
    }

    $cfile = new \CURLFile(
        $absoluteFilePath,
        mime_content_type($absoluteFilePath),
        basename($absoluteFilePath)
    );
    $postData = [
        'file' => $cfile
    ];
    $headers = [
        'Authorization: Zoho-oauthtoken ' . $credentials->access_token
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL            => $url,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $postData,
        CURLOPT_HTTPHEADER     => $headers,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
    ]);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        throw new \Exception(curl_error($ch));
    }
    curl_close($ch);
    return json_decode($response, true);
}
    

    public function createZohoCrmNotes($module,$record_id,$postData){
          $url = $module.'/'.$record_id.'/Notes';
        return $this->sendPostRequest($url,$postData);
    }
    
     public function convertleadintocontact($module,$record_id){
          $url = $module.'/'.$record_id.'/actions/convert';
    
         $postData = [
        'data' => [
            [
                'overwrite' => true
            ]
        ]
    ];
        return $this->sendPostRequest($url,$postData);
    }

    public function deleteZohoCrmRelatedList($module, $recordId, $relatedListApiName, $relatedRecordId = '') {
        $url = $module . '/' . $recordId . '/' . $relatedListApiName;
        return $this->sendDeleteRequest($url);
    }

    public function sendDeleteRequest($url) {
        $credentials = $this->getAccessToken();
        if (isset($credentials->access_token)) {
        // $postData = json_encode($postData);
            $headers = array(
            'Authorization: Zoho-oauthtoken ' . $credentials->access_token,
            'Content-type: application/x-www-form-urlencoded;charset=UTF-8'
        );
            $ch = curl_init(); // Create a curl handle
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); // Set curl handle header
            curl_setopt($ch, CURLOPT_URL, $url); // Third party API URL
            curl_setopt($ch, CURLOPT_POST, FALSE);  // To set POST method true
            // curl_setopt($ch, CURLOPT_POSTFIELDS, $postData); // To send data to the API URL
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE); // To set SSL Verifier false
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); // To set return response from the API
            return curl_exec($ch); // To execute the handle and get the response
            // $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Get Http Status code
        }
    }

    public function sendPutRequest($url, $postData) {
        $url = $this->zohoUrl . $url;
        $credentials = $this->getAccessToken();
        if (isset($credentials->access_token)) {
            $postData = json_encode($postData);
            $headers = array(
            'Authorization: Zoho-oauthtoken ' . $credentials->access_token,
            'Content-type: application/x-www-form-urlencoded;charset=UTF-8'
        );
            $ch = curl_init(); // Create a curl handle
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); // Set curl handle header
            curl_setopt($ch, CURLOPT_URL, $url); // Third party API URL
            curl_setopt($ch, CURLOPT_POST, FALSE);  // To set POST method true
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData); // To send data to the API URL
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE); // To set SSL Verifier false
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); // To set return response from the API
            return curl_exec($ch); // To execute the handle and get the response
            // $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Get Http Status code
        }
    }


     public function sendPhotoUploadRequest($url, $filePath)
{
   $url = 'https://www.zohoapis.in/crm/v8/files';
    $credentials = $this->getAccessToken();

    $postData = [
        'file' => new \CURLFile(
            $filePath,
            mime_content_type($filePath),
            basename($filePath)
        )
    ];

    $headers = [
        'Authorization: Zoho-oauthtoken ' . $credentials->access_token
    ];
   

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);

    return [
        'status' => $httpCode,
        'response' => $response
    ]; 
}


    public function sendPostRequest($url, $postData) {
        $url = $this->zohoUrl . $url;
        $credentials = $this->getAccessToken();
        if (isset($credentials->access_token)) {
            $postData = json_encode($postData);
            //echo"<pre>";print_r($postData);
           $headers = array(
            'Authorization: Zoho-oauthtoken ' . $credentials->access_token,
            'Content-type: application/x-www-form-urlencoded;charset=UTF-8'
        );
            $ch = curl_init(); // Create a curl handle
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); // Set curl handle header
            curl_setopt($ch, CURLOPT_URL, $url); // Third party API URL
            curl_setopt($ch, CURLOPT_POST, FALSE);  // To set POST method true
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData); // To send data to the API URL
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE); // To set SSL Verifier false
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); // To set return response from the API
            return curl_exec($ch); // To execute the handle and get the response
            // $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Get Http Status code
        }
    }

    public function sendGetRequest($url) {
        $url = $this->zohoUrl . $url;
        
     
        $credentials = $this->getAccessToken();
        if (isset($credentials->access_token)) {
            
            $headers = array(
            'Authorization: Zoho-oauthtoken ' . $credentials->access_token,
            'Content-type: application/x-www-form-urlencoded;charset=UTF-8'
        );
            $ch = curl_init(); // Create a curl handle
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); // Set curl handle header
            curl_setopt($ch, CURLOPT_URL, $url); // Third party API URL
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE); // To set SSL Verifier false
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); // To set return response from the API
            
            return curl_exec($ch); // To execute the handle and get the response
            // $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Get Http Status code
        }
    }


    public function getZohoCrmRelatedRecords($module,$recordId,$api_name){
        $url = $module.'/'.$recordId.'/'.$api_name.'?fields=Owner';
        return $this->sendGetRequest($url);
    }

}