<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShareHoldingPattern extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'shareholding_pattern';

    // Primary key
    protected $primaryKey = 'id';

    // Only created_at exists
    public $timestamps = false;

    // Mass assignable fields
    protected $fillable = [
        'company_info_id',
        'category',
        'sub_category',
        'pre_issue_shares',
        'pre_issue_percentage',
        'post_issue_shares',
        'post_issue_percentage',
        'category_order',
        'created_at',
    ];

    // Casts
    protected $casts = [
        'company_info_id'       => 'integer',
        'pre_issue_shares'      => 'integer',
        'pre_issue_percentage'  => 'decimal:2',
        'post_issue_shares'     => 'integer',
        'post_issue_percentage' => 'decimal:2',
        'category_order'        => 'integer',
        'created_at'            => 'datetime',
    ];

    // Relationship
    public function companyInfo()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
