<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FinancialSummaryData extends Model


{
    
    protected $table = 'financial_summary_data';
    protected $fillable = [
        'company_info_id',
        'present_offer_size',
        'paid_up_capital_after_offer',
        'paid_up_capital_after_conversion',
        'share_premium_before_offer',
        'last_year_allotment_details',
        'dividends_declared_last_3_years',
        'accounting_policy_changes',
    ];

    public function company()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
