<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FinancialCondition extends Model
{
    use HasFactory;

    protected $table = 'financial_position'; // change if table name is different

    protected $fillable = [
        'company_info_id',
        'financial_year',
        'net_profit_loss',
    ];

    public $timestamps = true; // created_at exists

     public function company()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }

}
