<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CapitalStructure extends Model
{
    use HasFactory;

    // Table name (change if needed)
    protected $table = 'capital_structure';

    // Primary key
    protected $primaryKey = 'id';

    // Only created_at exists
    public $timestamps = false;

    // Mass assignable fields
    protected $fillable = [
        'company_info_id',
        'category',
        'authorized_capital',
        'issued_capital',
        'subscribed_capital',
        'paid_up_capital',
        'created_at',
    ];

    // Type casting
    protected $casts = [
        'company_info_id'      => 'integer',
        'authorized_capital'   => 'decimal:2',
        'issued_capital'       => 'decimal:2',
        'subscribed_capital'   => 'decimal:2',
        'paid_up_capital'      => 'decimal:2',
        'created_at'           => 'datetime',
    ];

    // Relationship (optional)
    public function companyInfo()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
