<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccountingPolicy extends Model
{
    use HasFactory;

    // Table name (change if different)
    protected $table = 'accounting_policies';

    // Primary key
    protected $primaryKey = 'id';

    // If only created_at exists (no updated_at)
    public $timestamps = false;

    // Allow mass assignment
    protected $fillable = [
        'company_info_id',
        'policy_changes',
        'effects_on_profits',
        'created_at',
    ];

    // Optional: cast fields
    protected $casts = [
        'company_info_id' => 'integer',
        'created_at'      => 'datetime',
    ];

    // Optional: relationship example
    public function companyInfo()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
