<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\User;
use App\Traits\ZohoCrmTrait;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;



class UploadWebcamPhotoToZoho implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
     use ZohoCrmTrait; 

    protected $userId;
    protected $path;
    

    public function __construct($userId, $path)
    {
        $this->userId = $userId;
        $this->path = $path;
    }

    public function handle()
    {
        $user = User::find($this->userId);
        if (!$user) {
            session()->put('zoho_webcam', 'user_not_found');
            return;
        }

        $contactZohoId = $user->contactzohoid;
        $module = 'Contacts';

       
        //$fullPath = storage_path('app/' . $this->path);
        
        $fullPath = Storage::disk('local')->path($this->path);

            if (!file_exists($fullPath)) {
                Log::error('Webcam file not found', [
                    'path' => $fullPath
                ]);
                return;
            }

        $photoResponse = $this->updateZohoCrmRecordPhoto(
            $module,
            $contactZohoId,
            $fullPath
        );

        $fileId = null;

        if (isset($photoResponse['response'])) {
            $decoded = json_decode($photoResponse['response'], true);

            if (
                isset($decoded['data'][0]['code']) &&
                $decoded['data'][0]['code'] === 'SUCCESS'
            ) {
                $fileId = $decoded['data'][0]['details']['id'] ?? null;
            }
        }

        if (!$fileId) {
            Log::error('Zoho webcam upload failed', $photoResponse);
            session()->put('zoho_webcam', 'failed');
            return;
        }

        // $payload = [
        //     'data' => [[
        //         'Webcam_Verification_Photo1' => $fileId,
        //         'Verification_Step'         => '5'
        //     ]]
        // ];
        
        $payload = [
    'data' => [
        [
            'id' => $user->contactzohoid, // REQUIRED for subform update
            'Webcam_Verification_Photo' => [
                [
                    'File_Id__s' => $fileId
                ]
            ],
            'Verification_Step' => '6',
            'Webcam_Verification' => true,
        ]
    ]
];
        Log::info('payload', [
           
            'payload' => $payload
        ]);

        $response = $this->updateZohoCrmRecord(
            'Contacts',
            $contactZohoId,
            $payload
        );

        Log::info('Zoho webcam upload response', [
            'user_id' => $this->userId,
            'response' => $response
        ]);

        session()->put('zoho_webcam', 'success');
    }
}
