<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\User;
use App\Traits\ZohoCrmTrait;
use Illuminate\Support\Facades\Log;

class SyncUserToZoho implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    use ZohoCrmTrait; // ✅ THIS IS THE FIX

    protected $userId;
    protected $data;
    protected $photoPath;

    public function __construct($userId, $data, $photoPath = null)
    {
        $this->userId    = $userId;
        $this->data      = $data;
        $this->photoPath = $photoPath;
    }

    public function handle()
    {
        $user = User::find($this->userId);
        if (!$user) return;

        $fileId = null;

        if ($this->photoPath) {
            $fullPath = storage_path('app/private/' . $this->photoPath);

            $photoResponse = $this->updateZohoCrmRecordPhoto(
                'Contacts',
                $user->contactzohoid,
                $fullPath
            );

            $decoded = json_decode($photoResponse['response'] ?? null, true);

            if (
                isset($decoded['data'][0]['code']) &&
                $decoded['data'][0]['code'] === 'SUCCESS'
            ) {
                $fileId = $decoded['data'][0]['details']['id'] ?? null;
            }
        }

        $payload = [
            'data' => [[
                'id' =>  $user->contactzohoid,
                'First_Name'           => $this->data['first_name'],
                'Last_Name'            => $this->data['last_name'],
                'Email'                => $this->data['email'],
                'Phone'                => $this->data['phone'],
                'Gender'               => $this->data['gender'],
                'Profile_Pic' => [
                [
                    'File_Id__s' => $fileId
                ]
            ],
                'Your_Referral_Code'   => $user->referral_code,
                'Investor_Type'        => $user->usertype,
                'Verification_Step'    => '1',
            ]]
        ];

        $response = $this->updateZohoCrmRecord(
            'Contacts',
            $user->contactzohoid,
            $payload
        );

        Log::info('Zoho update response', [
    'user_id' => $this->userId,
    'response' => $response
]);

session()->put('zoho_sync', 'success');

        
    }
}
