<?php

namespace App\Http\Middleware;

use Closure;

class CheckKycStep
{
    public function handle($request, Closure $next, $requiredStep)
    {
        if (!session()->has('kyc_step')) {
            session(['kyc_step' => 0]);
        }

        $currentStep  = (int) session('kyc_step');
        $requiredStep = (int) $requiredStep;

        // ❌ Block direct URL jump
        if ($currentStep !== $requiredStep) {
            return redirect()
                ->route($this->getRedirectRoute($currentStep))
                ->with('error', 'Please complete the previous step first.');
        }

        return $next($request);
    }

    private function getRedirectRoute($step)
    {
        return match ($step) {
            0 => 'userdetailspage',
            1 => 'pancardpage',
            2 => 'aadharpage',
            3 => 'aadharkycpage2',
            4 => 'webcampage',
            5 => 'nomineepage',
            6 => 'user-detailspage',
            default => 'userdetailspage',
        };
    }
}
