<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AutoLogoutOnInactivity
{
    protected $timeout = 900;

    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {

            $lastActivity = session('last_activity');

            if ($lastActivity && (time() - $lastActivity) > $this->timeout) {

                Auth::logout();
                session()->invalidate();
                session()->regenerateToken();

                return redirect()->route('login')
                    ->with('error', 'You were logged out due to inactivity.');
            }

            session(['last_activity' => time()]);
        }

        return $next($request);
    }
}
