<?php

namespace App\Http\Controllers;

use App\Traits\ZohoCrmTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;
use App\Jobs\SyncUserToZoho;
use App\Jobs\UploadWebcamPhotoToZoho;


use App\Models\User;
use Symfony\Component\HttpFoundation\Response;


class UserDetailsController extends Controller
{


    use ZohoCrmTrait;
    
    
   
   public function userdetailspage()
{
    $user = auth()->user();
    $firstName = explode(' ', trim($user->name))[0];

    return view("user-profile", compact('user', 'firstName'));
}


public function avatar()
{
    $userId = auth()->id();
    $path = "profilephoto/{$userId}/avatar.jpg";

    if (!Storage::disk('local')->exists($path)) {
        // fallback default image
        return response()->file(public_path('images/avtar.png'));
    }

    return response()->file(
        storage_path("app/private/{$path}")
    );
}

    // public function saveuserdetails(Request $request)
    // {

    //   // $contactZohoId = auth()->user()->contact_zoho_id;

    //   $contactZohoId = "1137024000000935061";


    //     $request->validate([
    //         // Basic details
    //         'first_name' => 'required|string|max:50',
    //         'last_name' => 'required|string|max:50',
    //         'email' => 'required|email',
    //         'phone' => 'required|digits_between:8,15',

    //         // Radio fields
    //         'gender' => 'required',
    //         'Occupation' => 'required|string',
    //         'income' => 'required|string',
    //         'settlement' => 'required|string',

    //         // Products (radio / multi)
    //         'Products' => 'required|string',

    //         // Bank details
    //         'ifsc' => 'required|string|max:20',
    //         'bank' => 'required|string|max:50',
    //         'micr' => 'nullable|string|max:20',
    //         'branch' => 'required|string|max:50',
    //         'account_number' => 'required|numeric|digits_between:9,18',
    //         'confirm_account_number' => 'required|same:account_number',

    //         // Nominee
    //         'nominee_name' => 'required|string|max:100',
    //         'nominee_pan' => 'required|string|max:10',
    //         'nominee_dob' => 'required|date',
    //         'nominee_mobile' => 'required|digits_between:8,15',
    //         'nominee_email' => 'required|email',
    //         'nominee_relation' => 'required|string|max:50',
    //         'nominee_percentage' => 'required|integer|min:1|max:100',
    //         'address' => 'required',
    //     ]);

    //     $payload = [
    //         'data' => [
    //             [
    //                 'First_Name' => $request->first_name,
    //                 'Last_Name' => $request->last_name,
    //                 'Email' => $request->email,
    //                 'Phone' => $request->phone,
    //                 'Gender' => $request->gender,
    //                 'Occupation' => $request->Occupation,

    //                 'Annual_Income' => $request->income,
    //                 'Preference_for_Running_Account_Settlement' => $request->settlement,

    //                 'Products_you_like_to_start_with' => [
    //                     $request->Products
    //                 ],

    //                 'IFSC' => $request->ifsc,
    //                 'Bank' => $request->bank,
    //                 'MICR' => $request->micr,
    //                 'Branch' => $request->branch,
    //                 'Account_Number' => $request->account_number,
    //                 'Confirm_Account_Number' => $request->confirm_account_number,

    //                 'Nominee_Details' => [
    //                     [
    //                         'Nominee_s_Name' => $request->nominee_name,
    //                         'Nominee_s_PAN' => $request->nominee_pan,
    //                         'DOB' => $request->nominee_dob,
    //                         'Phone' => $request->nominee_mobile,
    //                         'Email' => $request->nominee_email,
    //                         'This_Nominee_is_my' => $request->nominee_relation,
    //                         'Percentage_of_Share' => (int) $request->nominee_percentage,
    //                         'Address_as_per_my_registered' => $request->address === 'Yes'
    //                     ]
    //                 ]
    //             ]
    //         ],

    //     ];


    //     $response = $this->updateZohoCrmRecord('Contacts', $contactZohoId, $payload);



    //  return back()->with('success', 'Your details have been saved successfully.');
    // }



public function saveuserdetails(Request $request)
{
    
     $request->validate([
        'first_name' => 'required|string|max:100',
        'last_name'  => 'required|string|max:100',
        'email'      => 'required|email',
        'phone'      => 'required|digits:10',
        'gender'     => 'required|in:Male,Female,Other',
        'photo'      => 'required|image|mimes:jpg,jpeg,png|max:2048',
    ], [
        'gender.required' => 'Please select your gender.',
        'photo.required'  => 'Profile photo is required.',
    ]);
    
    $photoPath = null;

    if ($request->hasFile('photo')) {
        $photoPath = $request->file('photo')
            ->storeAs(
                "profilephoto/" . auth()->id(),
                "avatar.jpg",
                'local'
            );
    }

    try {
        (new \App\Jobs\SyncUserToZoho(
            auth()->id(),
            $request->only([
                'first_name',
                'last_name',
                'email',
                'phone',
                'gender'
            ]),
            $photoPath
        ))->handle();

    } catch (\Exception $e) {
        \Log::error('Zoho Sync Failed', ['error' => $e->getMessage()]);
        session()->put('zoho_sync', 'failed');
    }
    
    session(['kyc_step' => 1]);

    return $request->action === 'complete_profile'
        ? redirect()->route('pancardpage')
        : redirect()->route('dashboard');
}


    public function pancardpage()
    {
        $user = auth()->user();
        return view("pan-kyc", compact('user'));
    }


    private function normalizeName(string $name): string
{
    $name = strtoupper($name);
    $name = preg_replace('/[^A-Z ]/', '', $name); // remove dots/special chars
    $name = preg_replace('/\s+/', ' ', trim($name));

    return $name;
}


    public function startPanKyc(Request $request)
{
    $request->validate([
        'pan_number' => 'required',
        'consent'    => 'required',
    ]);

     session([
        'pan_number' => $request->pan_number
    ]);

    $response = Http::post('https://vexilai.in/v1/api/GetPanDetail', [
        'Pan_number' => strtoupper($request->pan_number),
        'MemberId'   => '45278276',
        'ServiceId'  => '2',
    ]);

    $data = $response->json();

    if (empty($data['success']) || !$data['success']) {
        return back()->with('error', 'PAN verification failed');
    }


    $panNumber = $data['data']['pan_number'];
    $panNameRaw   = $data['data']['full_name'];
    $panclientid =  $data['data']['client_id'];

    // $firstname = auth()->user()->first_name;
    // $lastname= auth()->user()->last_name;
    
    $contactZohoId = auth()->user()->contactzohoid;

    $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
    $responseData = json_decode($response, true);

    if (empty($responseData['data'][0])) {
        abort(404, 'Zoho contact not found');
    }

    $contact = $responseData['data'][0];
    $firstname = $contact['First_Name'];
    $lastname = $contact['Last_Name'];
    

    $dbNameRaw = $firstname.' '.$lastname;

    $panName = $this->normalizeName($panNameRaw);
    $dbName  = $this->normalizeName($dbNameRaw);

    $panParts = explode(' ', $panName);
    $dbParts  = explode(' ', $dbName);

    $panFirst = $panParts[0] ?? '';
    $panLast  = end($panParts);

    $dbFirst  = $dbParts[0] ?? '';
    $dbLast   = end($dbParts);

    log::info($panFirst.''.$dbFirst.''.$dbLast.''.$panLast);

    if ($panFirst !== $dbFirst || $panLast !== $dbLast) {
        return back()->with(
            'error',
            'PAN name does not match with your profile name'
        );
    }




    $zohoContactId = auth()->user()->contactzohoid; 

    if ($zohoContactId) {
        $zohoPayload = [
            'data' => [
                [
                    'Pan_Client_Id' => $panclientid,
                    'PAN'      => $panNumber,
                    'PAN_Full_Name'=> $panName,
                    'PAN_Verification_Status'     => 'Verified',
                    'Verification_Step' =>'2'
                    
                ]
            ]
        ];

        $zohoResponse = $this->updateZohoCrmRecord(
            'Contacts',
            $zohoContactId,
            $zohoPayload
        );

        $zohoData = is_string($zohoResponse)
            ? json_decode($zohoResponse, true)
            : $zohoResponse;

  
        if (
            !isset($zohoData['data'][0]['code']) ||
            $zohoData['data'][0]['code'] !== 'SUCCESS'
        ) {
            return back()->with('error', 'PAN verified but Zoho update failed');
        }
    }

session(['kyc_step' => 2]);
    return redirect() ->route('aadharpage');
}


      public function aadharpage()
    {
        $user = auth()->user();
        return view("adhar-kyc-1", compact('user'));
    }

    public function startAadhaar(Request $request)
{
    $request->validate([
    'consent' => 'accepted',
], [
    'consent.accepted' => 'You must accept the consent to continue.',
]);

    $response = Http::post('https://vexilai.in/v1/api/DigiLockerAdhar', [
        'ServiceId'    => '1',
        'MemberId'     => '45278276',
        'redirect_url' => "https://beniss.crm-masters.com/aadhaar/callback",
    ]);

    $data = $response->json();

    if (empty($data['success'])) {
        return back()->with('error', 'Unable to start Aadhaar verification');
    }
    
      $user = Auth::user();
    $user->aadharclientid   = $data['client_id'];

    $user->save();

    // Store client_id temporarily in session (NO DB)
    session([
        'aadhaar_client_id' => $data['client_id']
    ]);

    return redirect()->away($data['URL']);
}




  public function aadhaarCallback(Request $request)
{

      $user = Auth::user();
      $clientId =  $user->aadharclientid  ;
   

    //$clientId = session('aadhaar_client_id');

    if (!$clientId) {
        Log::warning('Aadhaarclientid not found');


        return redirect()->route('aadharpage')
            ->with('error', 'Aadhaar session expired');
    }

    // Call Download Aadhaar API
    $response = Http::post('https://vexilai.in/v1/api/DownloadAdhar', [
        'ServiceId' => '1',
        'MemberId'  => '45278276',
        'Client_Id' => $clientId,
    ]);

    Log::info('Aadhaar API raw response', [
        'status' => $response->status(),
        'body'   => $response->body(),
    ]);

    $data = $response->json();

    if (empty($data['success'])) {
        Log::error('Aadhaar verification failed', [
            'response' => $data,
          // 'user_id'  => auth()->id(),
        ]);

        return redirect()->route('aadharpage')
            ->with('error', 'Aadhaar verification failed');
    }

    $aadhaar = $data['data']['aadhaar_xml_data'];

    Log::info('Aadhaar verified data extracted', [
        'aadhaar' => $aadhaar,
        //'user_id' => auth()->id(),
    ]);
    
     $contactZohoId = auth()->user()->contactzohoid;
    
    $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
    $responseData = json_decode($response, true);

    if (empty($responseData['data'][0])) {
        abort(404, 'Zoho contact not found');
    }
    
    $contact = $responseData['data'][0];
    $firstname = $contact['First_Name'];
    $lastname = $contact['Last_Name'];
    

    $profileNameRaw = $firstname.' '.$lastname;
    $aadhaarNameRaw = $aadhaar['full_name'];
    
    $profileName = $this->normalizeName($profileNameRaw);
    $aadhaarName = $this->normalizeName($aadhaarNameRaw);
    
    $profileParts = explode(' ', $profileName);
    $aadhaarParts = explode(' ', $aadhaarName);
    
    $profileFirst = $profileParts[0] ?? '';
    $profileLast  = end($profileParts);
    
    $aadhaarFirst = $aadhaarParts[0] ?? '';
    $aadhaarLast  = end($aadhaarParts);
    
    log::info($profileFirst. '  '.$aadhaarFirst .'  '.$profileLast.' '.$aadhaarLast);
    
    if ($profileFirst !== $aadhaarFirst || $profileLast !== $aadhaarLast) {
        return redirect()->route('aadharpage')->with('Name does not match with Aadhaar name');
    }


    // Prepare Zoho payload
    $zohoPayload = [
        'data' => [[
            'Aadhaar_Name'     => $aadhaar['full_name'] ?? null,
            'Gender'           => $aadhaar['gender'] === 'M' ? 'Male' : 'Female',
            'Date_of_Birth'    => $aadhaar['dob'] ?? null,
            'Aadhaar_Masked'   => $aadhaar['masked_aadhaar'] ?? null,
            'Aadhaar_Address' => $aadhaar['full_address'] ?? null,
            'Aadhaar_Verification_Status'   => 'Verified',
             'Father_s_Name'  => $aadhaar['care_of'] ?? null,
             'Verification_Step' =>'3'
        ]]
    ];

   
   
//   $contactZohoId = "1137024000000935061";

    Log::info('Updating Zoho contact', [
        'zoho_contact_id' => $contactZohoId,
        'payload'         => $zohoPayload,
    ]);

    $zohoResponse = $this->updateZohoCrmRecord(
        'Contacts',
        $contactZohoId,
        $zohoPayload
    );

    $zohoData = is_string($zohoResponse)
        ? json_decode($zohoResponse, true)
        : $zohoResponse;

    Log::info('Zoho API response', [
        'response' => $zohoData,
        // 'user_id'  => auth()->id(),
    ]);

    if (
        !isset($zohoData['data'][0]['code']) ||
        $zohoData['data'][0]['code'] !== 'SUCCESS'
    ) {
        Log::error('Zoho update failed after Aadhaar verification', [
            'zoho_response' => $zohoData,
            // 'user_id'       => auth()->id(),
        ]);

        return back()->with('error', 'Aadhar verified but Zoho update failed');
    }

    Log::info('Aadhaar verification & Zoho update successful', [
        // 'user_id' => auth()->id(),
        'zoho_contact_id' => $contactZohoId,
    ]);
    
    session(['kyc_step' => 3]);

    return redirect()->route('aadharkycpage2');
}




public function aadharkycpage2()
    {
        $user = auth()->user();
        return view("adhar-kyc-2", compact('user'));
    }



     public function saveaadharkytwo(Request $request)
    {
        // $contactZohoId = "1137024000000935061";
        
         $contactZohoId = auth()->user()->contactzohoid; 

        $request->validate([
                
            'status' => 'required',
            'Occupation' => 'required|string',
            'income' => 'required|string',
            'settlement' => 'required|string',
            'consent' => 'required'

        ]);

        $payload = [
            'data' => [
                [
                      'Marrital_Status' => $request->status,
                    'Occupation' => $request->Occupation,
                     'Interest_Frequency' =>$request->settlement,
                    'Annual_Income' => $request->income,
                    'Preference_for_Running_Account_Settlement' => $request->settlement,
                    'Verification_Step' =>'4'
                ]
            ]
        ];

        $response = $this->updateZohoCrmRecord('Contacts', $contactZohoId, $payload);

        $responseData = is_string($response) ? json_decode($response, true) : $response;


        if (isset($responseData['data'][0]['code']) && $responseData['data'][0]['code'] == 'SUCCESS') {
            
            session(['kyc_step' => 4]);
            
                return redirect()->route('bankdetailpage');
           
        } else {

            return back()->with('error', 'Failed to save details. Please try again.');
        }
    }
    
    
    public function bankdetailpage()
    {
        $user = auth()->user();
        return view("adhar-kyc-3", compact('user'));
    }



     public function savebankdetail(Request $request)
    {
        // $contactZohoId = "1137024000000935061";
        
         $contactZohoId = auth()->user()->contactzohoid; 

     
        
            $request->validate([
        'ifsc' => [
            'required',
            'regex:/^[A-Z]{4}0[A-Z0-9]{6}$/i'
        ],
        'branch' => 'required|string|max:100',
        'account_number' => 'required|string|min:6|max:20',
        'cnfrm_account_number' => 'required|string|same:account_number',
        'micr' => 'required|digits:9',
        'bank' => 'required|string|max:100',
    ]);

        $payload = [
            'data' => [
                [
                      'Bank' => $request->bank,
                    'MICR' => $request->micr,
                     'IFSC' =>$request->ifsc,
                    'Branch' => $request->branch,
                    'Account_Number' => $request->account_number,
                    'Confirm_Account_Number' => $request->cnfrm_account_number,
                    'Verification_Step' =>'5'
                ]
            ]
        ];

        $response = $this->updateZohoCrmRecord('Contacts', $contactZohoId, $payload);
        
      

        $responseData = is_string($response) ? json_decode($response, true) : $response;


        if (isset($responseData['data'][0]['code']) && $responseData['data'][0]['code'] == 'SUCCESS') {
            
            session(['kyc_step' => 5]);
            
                return redirect()->route('webcampage');
           
        } else {

            return back()->with('error', 'Failed to save details. Please try again.');
        }
    }


    public function webcampage()
    {
        $user = auth()->user();
        return view("webcam", compact('user'));
    }


    

// public function upload(Request $request)
// {
//     $request->validate([
//         'photo' => 'required|image|mimes:jpeg,jpg,png|max:5120',
//     ]);
    
//      $file = $request->file('photo');

//     // Size in KB
//     $sizeInKB = $file->getSize() / 1024;

//     // Size in MB
//     $sizeInMB = round($sizeInKB / 1024, 2);

//     Log::info('Uploaded photo size', [
//         'kb' => $sizeInKB,
//         'mb' => $sizeInMB
//     ]);

//     $contactZohoId = auth()->user()->contactzohoid;
//     $module = "Contacts";

//     // Store temporarily
//     $path = $request->file('photo')->store('webcam', 'local');
//     $fullPath = storage_path('app/private/' . $path);

//     // 1️⃣ Upload photo to Zoho
//     $photoResponse = $this->updateZohoCrmRecordPhoto(
//         $module,
//         $contactZohoId,
//         $fullPath
//     );

//     // 2️⃣ Extract file_id from Zoho response
//     $fileId = null;

//     if (
//         isset($photoResponse['response'])
//     ) {
//         $decoded = json_decode($photoResponse['response'], true);

//         if (
//             isset($decoded['data'][0]['code']) &&
//             $decoded['data'][0]['code'] === 'SUCCESS'
//         ) {
//             $fileId = $decoded['data'][0]['details']['id'] ?? null;
//         }
//     }

//     if (!$fileId) {
//         Log::error('Zoho photo upload failed', $photoResponse);

//         return response()->json([
//             'success' => false,
//             'message' => 'Zoho photo upload failed'
//         ], 500);
//     }

//     // 3️⃣ Update CRM field with file_id
//     $payload = [
//         'data' => [
//             [
//                 'Webcam_Verification_Photo1' => $fileId,
//                 'Verification_Step' =>'5'
//             ]
//         ]
//     ];

//     $response = $this->updateZohoCrmRecord(
//         'Contacts',
//         $contactZohoId,
//         $payload
//     );

//     $responseData = is_string($response)
//         ? json_decode($response, true)
//         : $response;
        
       
        
//         log::info($responseData);

//     if (
//         !isset($responseData['data'][0]['code']) ||
//         $responseData['data'][0]['code'] !== 'SUCCESS'
//     ) {
//         $zohoMessage = $responseData['data'][0]['message'] ?? 'Zoho update failed';

//         return response()->json([
//             'success' => false,
//             'message' => $zohoMessage
//         ], 500);
//     }

//     // ✅ All good
//     return response()->json([
//         'success' => true,
//         'message' => 'Photo uploaded and CRM updated successfully',
//         'file_id' => $fileId
//     ]);
// }

public function upload(Request $request)
{
    $request->validate([
        'photo' => 'required|image|mimes:jpeg,jpg,png|max:5120',
    ]);

    $file = $request->file('photo');

    Log::info('Uploaded photo size', [
        'kb' => $file->getSize() / 1024,
        'mb' => round(($file->getSize() / 1024) / 1024, 2)
    ]);

    // store locally (fast)
    $path = $file->store('webcam', 'local');

    try {
    (new \App\Jobs\UploadWebcamPhotoToZoho(
        auth()->id(),
        $path
    ))->handle();

    session(['kyc_step' => 6]);

    return response()->json([
        'success' => true
    ]);
} catch (\Exception $e) {
    Log::error('Webcam Zoho upload failed', [
        'error' => $e->getMessage()
    ]);

    return response()->json([
        'success' => false,
        'message' => 'Upload failed'
    ], 500);
}

    
    

    //return redirect()->route('nomineepage');
}





 public function nomineepage()
    {
        $user = auth()->user();
        return view("nominee", compact('user'));
    }

    public function storenomineedata(Request $request)
    {
        
        $request->validate([
    'nominees' => 'required|array|min:1',

    'nominees.*.name' => 'required|string|max:100',
    'nominees.*.relation' => 'required|string|max:50',
    'nominees.*.share' => 'required|numeric|min:1|max:100',
    'nominees.*.pan' => 'required|regex:/^[A-Z]{5}[0-9]{4}[A-Z]{1}$/',
    'nominees.*.dob' => 'required|date|before_or_equal:today',
    'nominees.*.mobile' => 'required|digits:10',
    'nominees.*.email' => 'required|email',
    'nominees.*.same_address' => 'required|in:0,1',
], [
    'nominees.*.name.required' => 'Nominee name is required.',
    'nominees.*.relation.required' => 'Relation is required.',
    'nominees.*.share.required' => 'Share percentage is required.',
    'nominees.*.share.max' => 'Share cannot exceed 100%.',
    'nominees.*.pan.required' => 'PAN is required.',
    'nominees.*.pan.regex' => 'PAN format is invalid.',
    'nominees.*.dob.required' => 'Date of birth is required.',
    'nominees.*.mobile.required' => 'Mobile number is required.',
    'nominees.*.mobile.digits' => 'Mobile number must be 10 digits.',
    'nominees.*.email.required' => 'Email is required.',
    'nominees.*.email.email' => 'Enter a valid email address.',
    'nominees.*.same_address.required' => 'Please select address option (Yes or No).',
    
]);
    

        $contactZohoId = auth()->user()->contactzohoid; 
        
        $user = auth()->user();
        
        if (!$user->Account_Id) {
            $user->Account_Id = User::generateAccountId();
            $user->save();
        }

       // $contactZohoId = "1137024000000935061";

        $subformData = [];

        foreach ($request->nominees as $nominee) {
            $subformData[] = [
                "Nominee_s_Name"     => $nominee['name'] ?? null,
                "Nominee_s_PAN"      => $nominee['pan'] ?? null,
                "DOB"      => $nominee['dob'] ?? null,
                "Phone"   => $nominee['mobile'] ?? null,
                "Email"    => $nominee['email'] ?? null,
                "This_Nominee_is_my" => $nominee['relation'] ?? null,
                "Percentage_of_Share"    => $nominee['share'] ?? null,
                 "Address_as_per_my_registered" =>(bool)$nominee['same_address'],
                 "Enter_Nominee_Address" => $nominee['other_address'] ?? null 
               
                
            ];
        }

        $payload = [
            'data' => [
                [
                      'Nominee_Details' => $subformData,
                      'Verification_Step' =>'7',
                      'Account_Id' => $user->Account_Id,
                     
                   
                ]
            ]
        ];
        
        $response = $this->updateZohoCrmRecord('Contacts', $contactZohoId, $payload);

        $responseData = is_string($response) ? json_decode($response, true) : $response;
        
      
        if (isset($responseData['data'][0]['code']) && $responseData['data'][0]['code'] == 'SUCCESS') {
            
            session(['kyc_step' => 7]);
            
                return redirect()->route('user-detailspage');
           
        } else {

            return back()->with('error', 'Failed to save details. Please try again.');
        }


    }

public function userdetailsdata()
{
    //$contactZohoId = "1137024000001239001";
     $contactZohoId = auth()->user()->contactzohoid;

    $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
    $responseData = json_decode($response, true);

    if (empty($responseData['data'][0])) {
        abort(404, 'Zoho contact not found');
    }

    $contact = $responseData['data'][0];

    $nominees = [];

    if (!empty($contact['Nominee_Details']) && is_array($contact['Nominee_Details'])) {
        foreach ($contact['Nominee_Details'] as $n) {
            $nominees[] = [
                'name'         => $n['Nominee_s_Name'] ?? '',
                'pan'          => $n['Nominee_s_PAN'] ?? '',
                'dob'          => $n['DOB'] ?? '',
                'mobile'       => $n['Phone'] ?? '',
                'email'        => $n['Email'] ?? '',
                'relation'     => $n['This_Nominee_is_my'] ?? '',
                'share'        => $n['Percentage_of_Share'] ?? '',
                'same_address' => !empty($n['Address_as_per_my_registered']) ? 'Yes' : 'No',
            ];
        }
    }

    return view('user-profile-details', compact('contact', 'nominees'));
}




 public function logout(Request $request)
    {
        // Logout user
        Auth::logout();

        // Destroy session completely
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('login')
            ->with('success', 'Logged out successfully.');
    }
    
    
    





}



