<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\UserService;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Str;
use App\Models\User;
use Illuminate\Support\Facades\Session;

class SignupController extends Controller
{

    protected $userService;

    public function __construct(UserService $userService)
    {
        $this->userService = $userService;
    }

    public function signup()
    {
        return view('index');
    }
    public function signupotp(Request $request)
    {

        $request->validate([
            //mobile' => 'required|digits:10|unique:users,mobile',
            'mobile' => 'required|digits:10',
            'referral' => 'nullable|string',
            'privacycheck' => 'accepted',
            'usertype' => 'required',
        ], [
            'privacycheck.accepted' => 'You must agree to the terms & privacy policy'
        ]);

        $data = $request->all();


        $result = $this->userService->signupWithOtp($data);

        if (!$result['success']) {
            return back()->withErrors([
                'mobile' => $result['message']
            ]);
        }

        session([
            'signup_mobile' => $data['mobile'],
            'refer_code' => $data['referral'] ?? null,
            'signup_privacycheck' => true,
            'signup_user_type' => $data['usertype'],
            'referal' => $data['referral']
        ]);


        return redirect()->route('otppage');


    }

    public function otppage()
    {
        $mobile = session('signup_mobile');

        if (!$mobile) {
            return redirect()->route('signup');
        }


        return view('otp', compact('mobile'));

    }

    public function verifyotp(Request $request)
    {
        $request->validate([
            'otp' => 'required|array|size:6',
            //'otp.*' => 'required|numeric'
        ]);
        $otp = implode('', $request->otp);

        $result = $this->userService->verifyOtp($otp);

        if (!$result['success']) {
            return back()->withErrors([
                'otp' => $result['message']
            ]);
        }

        return redirect()->route('emailsignuppage');
    }

    public function emailsignuppage()
    {
        return view('login_google');
    }



    public function sendotponemail(Request $request)
    {
        $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            // 'email' => 'required|email|unique:users,email',
             'email'     => 'required|email:rfc,dns',

        ]);

        $data = $request->all();

        $result = $this->userService->sendOtpOnEmail(
            $request->only('firstname', 'lastname', 'email')
        );

        if (!$result['success']) {
            return back()->withErrors([
                'email' => $result['message']
            ]);
        }

        session([
            'signup_email' => $data['email'],
            'signup_firstname' => $data['firstname'],
            'signup_lastname' => $data['lastname'],
        ]);


        return redirect()->route('emailotppage');
    }

    public function emailotppage()
    {
        $email = session('signup_email');

        if (!$email) {
            return redirect()->route('signup');
        }

        return view('emailverify', compact('email'));
    }

    public function verifyemailotp(Request $request)
    {

        $request->validate([
            'otp' => 'required|array|size:6',
           // 'otp.*' => 'required|numeric'
        ]);
        $otp = implode('', $request->otp);

        $result = $this->userService->verifyEmailOtp($otp);

        if (!$result['success']) {
            return back()->withErrors([
                'otp' => $result['message']
            ]);
        }

        return redirect()->route('passcodepage');

    }

    public function passcodepage()
    {
        return view('passcode');
    }
 
    
    public function createpasscode(Request $request)
{
    $request->validate([
        'passcode' => 'required|array|size:4',
        'passcode.*' => 'required|numeric',
        'passcode_confirmation' => 'required|array|size:4',
        'passcode_confirmation.*' => 'required|numeric',
    ], [
        'passcode.required' => 'Please enter your 4-digit passcode.',
        'passcode_confirmation.required' => 'Please reconfirm your passcode.',
    ]);

    $passcode = implode('', $request->passcode);
    $confirmPasscode = implode('', $request->passcode_confirmation);

    if ($passcode !== $confirmPasscode) {
        return back()->withErrors([
            'passcode' => 'Passcode and reconfirm passcode do not match.'
        ])->withInput();
    }

    $result = $this->userService->savePasscode($passcode);

    if (!$result['success']) {
        return back()->withErrors([
            'passcode' => $result['message']
        ]);
    }

    return redirect()->route('checkcontactinzoho');
}


    public function editSignup()
    {
        return redirect()
            ->route('signup')
            ->withInput([
                'mobile' => session('signup_mobile'),
                'refercode' => session('refer_code'),
                'privacycheck' => session('signup_privacycheck'),

            ]);
    }

    public function resendSmsOtp()
    {
        $mobile = session('signup_mobile');

        if (!$mobile) {
            return response()->json([
                'success' => false,
                'message' => 'Session expired'
            ], 419);
        }

        $this->userService->signupWithOtp([
            'mobile' => $mobile
        ]);

        return response()->json([
            'success' => true
        ]);
    }

    public function editSignupemail()
    {
        return redirect()
            ->route('emailsignuppage')
            ->withInput([
                'firstname' => session('signup_firstname'),
                'lastname' => session('signup_lastname'),
                'email' => session('signup_email'),


            ]);
    }

    public function resendEmailOtp()
    {
        $email = session('signup_email');
        $firstname = session('signup_firstname');
        $lastname = session('signup_lastname');
        
        $name = $firstname.' '.$lastname;

        if (!$email) {
            return response()->json([
                'success' => false,
                'message' => 'Session expired'
            ], 419);
        }

        $this->userService->sendOtpOnEmail([
            'firstname' => $firstname,
            'lastname' => $lastname,
            'email' => $email
        ]);

        return response()->json([
            'success' => true
        ]);
    }


    public function redirect()
    {
        return Socialite::driver('google')->redirect();
    }

    public function callback()
    {
        try {
            $googleUser = Socialite::driver('google')->stateless()->user();
        } catch (\Exception $e) {
            return redirect()->route('emailsignuppage')
                ->withErrors(['google' => 'Google authentication failed']);
        }

        $result = $this->userService->handleGoogleSignup([
            'google_id' => $googleUser->id,
            'email'     => $googleUser->email,
            'name'      => $googleUser->name,
        ]);

        if (! $result['success']) {
            return redirect()->route('emailsignuppage')
                ->withErrors(['email' => $result['message']]);
        }

        return redirect()->route('emailotppage');
    }






























}
