<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\ZohoCrmTrait;
use Illuminate\Support\Facades\Mail;
use App\Mail\LoginLinkMail;
use App\Models\User;

class CheckUserExistence extends Controller
{
    //
    use ZohoCrmTrait;

public function checkcontactinzoho(Request $request)
{
    $email     = session('signup_email');
    $phone     = session('signup_mobile');
    $firstname = session('signup_firstname');
    $lastname  = session('signup_lastname');
    $referal = session('referal');
    $usertype = session('signup_user_type');

    if (!$email && !$phone) {
        return back()->with('error', 'Email or phone missing');
    }

    $criteria = $email ? "email=$email" : "phone=$phone";

    /* -------------------- SEARCH CONTACT -------------------- */
    $contactResponse = $this->searchRecords('Contacts', $criteria);
    $contactResponse = json_decode($contactResponse, true);

    if (!empty($contactResponse['data'])) {

        $zohoContactId = $contactResponse['data'][0]['id'];

        User::where('email', $email)->update([
            'contactzohoid' => $zohoContactId
        ]);

        return redirect()->route('login');
    }

    /* -------------------- SEARCH LEAD -------------------- */
    $leadResponse = $this->searchRecords('Leads', $criteria);
    $leadResponse = json_decode($leadResponse, true);

    if (!empty($leadResponse['data'])) {

        $leadId = $leadResponse['data'][0]['id'] ?? null;

        if ($leadId) {
            $convertResponse = $this->convertleadintocontact("Leads", $leadId);
            $convertResponse = json_decode($convertResponse, true);

            if (
                isset($convertResponse['data'][0]['code']) &&
                $convertResponse['data'][0]['code'] === 'SUCCESS'
            ) {
                $contactId = $convertResponse['data'][0]['details']['Contacts']['id'] ?? null;

                if ($contactId) {
                    User::where('email', $email)->update([
                        'contactzohoid' => $contactId
                    ]);
                    
                    $dealresponse = $this->createdeal($contactId , $firstname ,$lastname);
                    $dealcreation = json_decode($dealresponse, true);
                    
                    if (isset($dealcreation['data'][0]['code']) && $dealcreation['data'][0]['code'] === 'SUCCESS') {
                    

                    return redirect()->route('login'); }
                }
            }

            return back()->with('error', 'Lead found but conversion failed.');
        }

        return back()->with('error', 'Lead found but ID missing.');
    }

    /* -------------------- CREATE LEAD -------------------- */
    $createLeadResponse = $this->createlead($email, $phone, $firstname, $lastname );
    
     $createLeadResponse = json_decode($createLeadResponse, true);

    if ( isset($createLeadResponse['data'][0]['code']) && $createLeadResponse['data'][0]['code'] === 'SUCCESS' ) {
        $leadId = $createLeadResponse['data'][0]['details']['id'] ?? null;

        if ($leadId) {
            $convertResponse = $this->convertleadintocontact("Leads", $leadId);
            $convertResponse = json_decode($convertResponse, true);

            if (isset($convertResponse['data'][0]['code']) && $convertResponse['data'][0]['code'] === 'SUCCESS') {
                $contactId = $convertResponse['data'][0]['details']['Contacts']['id'] ?? null;

                if ($contactId) {
                    User::where('email', $email)->update([
                        'contactzohoid' => $contactId
                    ]);
                    
                    $dealresponse = $this->createdeal($contactId , $firstname ,$lastname);
                    $dealcreation = json_decode($dealresponse, true);
                    
                    if (isset($dealcreation['data'][0]['code']) && $dealcreation['data'][0]['code'] === 'SUCCESS') {
                    

                    return redirect()->route('login'); }

                    
                }
            }

            return back()->with('error', 'Lead created but conversion failed.');
        }
    }

    return back()->with('error', 'Lead creation failed. Please try again.');
}


   public function sendLoginLink($email)
{
    if (!$email) {
        return;
    }
    Mail::to($email)->send(new LoginLinkMail());
}

public function createlead($email, $phone ,$firstname , $lastname ){
    
    

    $data = [
        'data' => [[
            'First_Name' =>$firstname,
            'Last_Name' =>$lastname,
            'Email'     => $email,
            'Phone'     => $phone,
           
            
        ]]
    ];

    return $this->createZohoCrmRecord('Leads', $data);

}

public function createdeal($contactid ,$firstname , $lastname ){
    
    

    $data = [
        'data' => [[
            'Deal_Name' => 'KYC -'.$firstname.''.$lastname,
            'Stage' =>   'Basic Details',
            'Contactid' => $contactid,
            'Pipeline'     => 'KYC',
            'Type'     => 'KYC',
           
            
        ]]
    ];

    return $this->createZohoCrmRecord('Deals', $data);

}




}