<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class MakeService extends Command
{
    protected $signature = 'make:service {name}';
    protected $description = 'Create a service class';

    public function handle(): void
    {
        $name = $this->argument('name');

        $serviceDir = app_path('Services');

        // Create the directory if it doesn't exist
        if (! File::exists($serviceDir)) {
            File::makeDirectory($serviceDir, 0755, true);
        }

        $servicePath = "{$serviceDir}/{$name}.php";

        if (File::exists($servicePath)) {
            $this->error('Service already exists!');
            return;
        }

        // Generate the service class file
        File::put($servicePath, <<<PHP
<?php

namespace App\Services;

class {$name}Service
{
    //
}
PHP);

        $this->info("Service {$name}Service created successfully ✅");
    }
}
