<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class MakeRepository extends Command
{
    protected $signature = 'make:repo {name}';
    protected $description = 'Create a repository class';

    public function handle(): void
    {
        $name = $this->argument('name');

        $repoDir = app_path('Repositories');

        if (! File::exists($repoDir)) {
            File::makeDirectory($repoDir, 0755, true);
        }

        $repoPath = "{$repoDir}/{$name}.php";

        if (File::exists($repoPath)) {
            $this->error('Repository already exists!');
            return;
        }

        File::put($repoPath, <<<PHP
<?php

namespace App\Repositories;

class {$name}
{
    //
}
PHP);

        $this->info("Repository {$name} created successfully ✅");
    }
}
